#include "mbed.h"
#include "C12832.h"
#include "LM75B.h"
#include "MMA7660.h"

C12832     lcd(D11, D13, D12, D7, D10);
AnalogIn   pot1(A0);
AnalogIn   pot2(A1);
LM75B      sensor(I2C_SDA, I2C_SCL);
//MMA7660    acc(I2C_SDA, I2C_SCL);

DigitalOut led_tcik(LED_BLUE);
DigitalOut myled(D8);
PwmOut     pwm_led(D9);
PwmOut     usr_led(LED_USER);

Ticker ficker;

void flip() {
    led_tcik = !led_tcik;
}

int main() {
    int cnt = 0;
    myled = 1;
    ficker.attach(&flip, 1);
    
    lcd.cls();
    lcd.locate(0, 0);
    lcd.printf("GR-PEACH & App shield!");
    //printf("GR-PEACH + mbed app shield!\n");

    while(1) {
        lcd.locate(0,15);
        lcd.printf("Counting: %d", cnt);
        
        lcd.locate(70,15);
        lcd.printf("p1=%f", pot1.read());
        lcd.locate(70,15+8);
        lcd.printf("p2=%f", pot2.read());
        lcd.locate(20,15+8);
        lcd.printf("%8.3f", sensor.read());
        pwm_led = pot1.read();
        usr_led = 1.0f - pot2.read();

        //lcd.locate(0,8);
        //lcd.printf("%6.2f, %6.2f, %6.2f\n", acc.x(), acc.y(), acc.z());

        myled = !myled;
        cnt++;
        wait(0.5);
    }
}
