/* * * * * * * * * * * * * * * * * * * * * * * * * * *
 * This drives the popular QDSP-6064 bubble display. *
 *                                                   *
 * Created by: Michael Dushkoff (mad1841@rit.edu)    *
 * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef BUBBLE_DISPLAY_H
#define BUBBLE_DISPLAY_H

#include "mbed.h"

// Definitions
#define DEF_DISPL_FREQ (10000.0) // 10kHz display frequency

// LUT for character to display
const char dispTabl[] = {
    0x7E, // 0
    0x30, // 1
    0x6D, // 2
    0x79, // 3
    0x33, // 4
    0x5B, // 5
    0x5F, // 6
    0x70, // 7
    0x7F, // 8
    0x7B, // 9
    0x77, // 10  "A"
    0x1F, // 11  "B"
    0x4E, // 12  "C"
    0x3D, // 13  "D"
    0x4F, // 14  "E"
    0x47, // 15  "F"
    0x00, // 16  NO DISPLAY
    0x00, // 17  NO DISPLAY
    0x00, // 18  NO DISPLAY
    0x00, // 19  NO DISPLAY
    0x00, // 20  NO DISPLAY
    0x00, // 21  NO DISPLAY
    0x00, // 22  NO DISPLAY
    0x00, // 23  NO DISPLAY
    0x00, // 24  NO DISPLAY
    0x00, // 25  NO DISPLAY
    0x00, // 26  NO DISPLAY
    0x00, // 27  NO DISPLAY
    0x00, // 28  NO DISPLAY
    0x00, // 29  NO DISPLAY
    0x00, // 30  NO DISPLAY
    0x00, // 31  NO DISPLAY
    0x00, // 32 ' '
    0x00, // 33 '!'  NO DISPLAY
    0x22, // 34 '"'
    0x00, // 35 '#'  NO DISPLAY
    0x00, // 36 '$'  NO DISPLAY
    0x00, // 37 '%'  NO DISPLAY
    0x00, // 38 '&'  NO DISPLAY
    0x20, // 39 '''
    0x4E, // 40 '('
    0x78, // 41 ')'
    0x00, // 42 '*'  NO DISPLAY
    0x00, // 43 '+'  NO DISPLAY
    0x04, // 44 ','
    0x01, // 45 '-'
    0x80, // 46 '.'  Decimal
    0x00, // 47 '/'  NO DISPLAY
    0x7E, // 48 '0'
    0x30, // 49 '1'
    0x6D, // 50 '2'
    0x79, // 51 '3'
    0x33, // 52 '4'
    0x5B, // 53 '5'
    0x5F, // 54 '6'
    0x70, // 55 '7'
    0x7F, // 56 '8'
    0x7B, // 57 '9'
    0x00, // 58 ':'  NO DISPLAY
    0x00, // 59 ';'  NO DISPLAY
    0x00, // 60 '<'  NO DISPLAY
    0x00, // 61 '='  NO DISPLAY
    0x00, // 62 '>'  NO DISPLAY
    0x00, // 63 '?'  NO DISPLAY
    0x00, // 64 '@'  NO DISPLAY
    0x77, // 65 'A'
    0x1F, // 66 'B'
    0x4E, // 67 'C'
    0x3D, // 68 'D'
    0x4F, // 69 'E'
    0x47, // 70 'F'
    0x5E, // 71 'G'
    0x37, // 72 'H'
    0x30, // 73 'I'
    0x38, // 74 'J'
    0x00, // 75 'K'  NO DISPLAY
    0x0E, // 76 'L'
    0x00, // 77 'M'  NO DISPLAY
    0x15, // 78 'N'
    0x7E, // 79 'O'
    0x67, // 80 'P'
    0x73, // 81 'Q'
    0x05, // 82 'R'
    0x5B, // 83 'S'
    0x0F, // 84 'T'
    0x3E, // 85 'U'
    0x00, // 86 'V'  NO DISPLAY
    0x00, // 87 'W'  NO DISPLAY
    0x00, // 88 'X'  NO DISPLAY
    0x3B, // 89 'Y'
    0x00, // 90 'Z'  NO DISPLAY
    0x4E, // 91 '['
    0x00, // 92 '\'  NO DISPLAY
    0x78, // 93 ']'
    0x00, // 94 '^'  NO DISPLAY
    0x08, // 95 '_'
    0x02, // 96 '`'
    0x77, // 97 'a' SAME AS CAP
    0x1F, // 98 'b' SAME AS CAP
    0x0D, // 99 'c'
    0x3D, // 100 'd' SAME AS CAP
    0x6F, // 101 'e'
    0x47, // 102 'f' SAME AS CAP
    0x5E, // 103 'g' SAME AS CAP
    0x17, // 104 'h'
    0x10, // 105 'i'
    0x38, // 106 'j' SAME AS CAP
    0x00, // 107 'k'  NO DISPLAY
    0x30, // 108 'l'
    0x00, // 109 'm'  NO DISPLAY
    0x15, // 110 'n' SAME AS CAP
    0x1D, // 111 'o'
    0x67, // 112 'p' SAME AS CAP
    0x73, // 113 'q' SAME AS CAP
    0x05, // 114 'r' SAME AS CAP
    0x5B, // 115 's' SAME AS CAP
    0x0F, // 116 't' SAME AS CAP
    0x1C, // 117 'u'
    0x00, // 118 'b'  NO DISPLAY
    0x00, // 119 'w'  NO DISPLAY
    0x00, // 120 'x'  NO DISPLAY
    0x00, // 121 'y'  NO DISPLAY
    0x00, // 122 'z'  NO DISPLAY
    0x00, // 123 '0b'  NO DISPLAY
    0x00, // 124 '|'  NO DISPLAY
    0x00, // 125 ','  NO DISPLAY
    0x00, // 126 '~'  NO DISPLAY
    0x00, // 127 'DEL'  NO DISPLAY
};

class BubbleDisplay{
public:
    /*
     * This is the default BubbleDisplay constructor that
     * maps the pins in a simple way for the LPC11U24.
     */ 
    BubbleDisplay();

    /*
     * This allows a user to map the pins of the bubble display
     * to any possible pin that they desire.
     */
    BubbleDisplay(PinName m0, PinName m1, PinName m2, PinName m3,
                  PinName m4, PinName m5, PinName m6, PinName m7,
                  PinName m8, PinName m9, PinName m10, PinName m11);
                  
    /*
     * Default destructor
     */
    ~BubbleDisplay();
                  
    /*
     * This sets the cycle frequency to a specific value instead of the
     * default 10kHz.
     */
     void setFreq(double freq);
    
    /*
     * This writes a sequence of characters from left to right
     * to the seven-segment displays.
     */
    void write(char c1, char c2, char c3, char c4);
    
    /*
     * This writes a sequence of characters from left to right
     * to the seven-segment displays.
     */
    void write(char* c);

    /*
     * This writes a sequence of integer number
     * to the seven-segment displays.
     */
    void write(uint16_t num);

private:
    /*
     * This is a constructor helper function
     */
    void init(PinName m0, PinName m1, PinName m2, PinName m3,
                  PinName m4, PinName m5, PinName m6, PinName m7,
                  PinName m8, PinName m9, PinName m10, PinName m11);
    
    /*
     * This cycles through the four seven segment displays on the
     * bubble display by switching on and off the correct cathodes.
     */
    void cycle();
    
    /* Private variables */
    Ticker _cycler;
    double _freq; // The cycle frequency
    char _seg; // The current display number
    // All of the pins
    DigitalOut* _cat1;
    DigitalOut* _anE;
    DigitalOut* _anC;
    DigitalOut* _cat3;
    DigitalOut* _anDP;
    DigitalOut* _cat4;
    DigitalOut* _anG;
    DigitalOut* _anD;
    DigitalOut* _anF;
    DigitalOut* _cat2;
    DigitalOut* _anB;
    DigitalOut* _anA;
    // Segement values
    char _chrs[4];
};

#endif