#include "mbed.h"
#include "BMP280_SPI.h"

Serial pc(USBTX, USBRX);
#if defined(TARGET_LPC1768)
BMP280_SPI sensor(p5, p6, p7, p8); // mosi, miso, sclk, cs
#elif defined(TARGET_NUCLEO_F401RE)
BMP280_SPI sensor(D4, D5, D3, D7); // mosi, miso, sclk, cs
#endif

int main() {
    
    while(1) {
        pc.printf("%2.2f degC, %04.2f hPa\n", sensor.getTemperature(), sensor.getPressure());
        wait(1);
    }
}
