#include "mbed.h"
#include "SB1602E.h"
#include "BME280.h"
#include "SDFileSystem.h"

#define USE_SDCARD  1
#define USE_RTC     0

#if USE_SDCARD
DigitalOut sd_sdo(dp18, 0);
DigitalOut sd_csb(dp15, 1);
DigitalOut sd_gnd(dp12, 0);
SDFileSystem sd(dp24, dp22, dp23, dp25, "sd"); // mosi, miso, sclk, cs
#endif

SB1602E lcd(dp11, dp10);
DigitalIn btn(dp2);
BME280 sensor(dp16, dp17);


int main()
{
    float temp, humd, pres;
    lcd.setCharsInLine(8);
    lcd.contrast(0x30);
    int last_mode = 0;
    btn.mode(PullUp);

    lcd.printf(0, 0, "BME280");
    lcd.printf(0, 1, "Demo");
    wait(3);

#if USE_SDCARD
    uint32_t count = 0;
    mkdir("/sd/environmental", 0777);
    FILE *fp = fopen("/sd/environmental/log.csv", "w");
    if(fp == NULL) {
        error("Could not open file for write\n");
    }
    fprintf(fp, "Temerature,Humidity,Pressure\r\n");
#endif

    while(1) {
        temp = sensor.getTemperature();
        humd = sensor.getHumidity();
        pres = sensor.getPressure();
        if (btn == 1) {
            if (last_mode == 0) {
                lcd.clear();
            }
            lcd.printf(0, 0, "%2.2f%cC", temp, 0xdf);
            lcd.printf(0, 1, "%2.2f%%", humd);
            last_mode = 1;
        } else {
            if (last_mode == 1) {
                lcd.clear();
            }
            lcd.printf(0, 0, "%2.2f%cC", temp, 0xdf);
            lcd.printf(0, 1, "%04.1fhPa", pres);
            last_mode = 0;
        }
#if USE_SDCARD
        count++;
        if ((count % (60 * 5)) == 0) {
            fprintf(fp, "%2.2f,%2.2f,%4.1f\r\n", temp, humd, pres);
            fflush(fp);
            count = 0;
        }
#endif
        wait(1);
    }

#if USE_SDCARD
    fclose(fp);
    delete fp;
#endif
}
