#include "mbed.h"
#include "SB1602E.h"
#include "BME280.h"

SB1602E lcd(I2C_SDA, I2C_SCL);
BME280 sensor(I2C_SDA, I2C_SCL);
DigitalIn btn(dp15);

int main()
{
    lcd.setCharsInLine(8);
    lcd.contrast(0x30);
    int last_mode = 0;
    btn.mode(PullUp);

    lcd.printf(0, 0, "BME280");
    lcd.printf(0, 1, "Demo");
    wait(5);
    
    while(1) {
        if (btn == 1) {
            if (last_mode == 0)
                lcd.clear();
            lcd.printf(0, 0, "%2.2f%cC", sensor.getTemperature(), 0xdf);
            lcd.printf(0, 1, "%2.2f%%", sensor.getHumidity());
            last_mode = 1;
        }
        else {
            if (last_mode == 1)
                lcd.clear();
            lcd.printf(0, 0, "%2.2f%cC", sensor.getTemperature(), 0xdf);
            lcd.printf(0, 1, "%04.1fhPa", sensor.getPressure());
            last_mode = 0;            
        }
        wait(1);
    }
}
