#include "mbed.h"
#include "BME280.h"

Serial pc(USBTX, USBRX);

#if defined(TARGET_LPC1768)
BME280 sensor(p28, p27);
#elif defined(TARGET_TY51822R3)
BME280 sensor(P0_30, P0_7);
#else
BME280 sensor(SDA, SCL);
#endif

int main() {
    
    while(1) {
        pc.printf("%2.2f degC, %04.2f hPa, %2.2f %%\n", sensor.getTemperature(), sensor.getPressure(), sensor.getHumidity());
        wait(1);
    }
}
