/* AS289R2 library test program
 * Copyright (c) 2016, Toyomasa Watarai
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#include "mbed.h"
#include "AS289R2.h"

Serial pc(USBTX, USBRX);
AS289R2 tp(D1);

const char url[] = "https://developer.mbed.org/components/AS-289R2-Thermal-Printer-Shield/";

int main()
{
    tp.initialize();
    tp.putLineFeed(2);

    tp.printf("** Thermal Printer Shield **\r\r");

    tp.setDoubleSizeWidth();
    tp.printf("  AS-289R2\r\r");
    tp.clearDoubleSizeWidth();

    tp.printf("日本語文字列の印字テスト:24x24\r");
    tp.setKanjiFont(AS289R2::KANJI_16x16);
    tp.setANKFont(AS289R2::ANK_8x16);
    tp.printf("日本語文字列の印字テスト:16x16\r\r");

    tp.setKanjiFont(AS289R2::KANJI_DEFAULT);
    tp.setANKFont(AS289R2::ANK_DEFAULT);
    tp.setDoubleSizeWidth();
    tp.printf("ABCDEFG 0123456789\r");
    tp.clearDoubleSizeWidth();

    tp.setDoubleSizeHeight();
    tp.printf("ABCDEFG 0123456789\r");
    tp.clearDoubleSizeHeight();

    tp.putLineFeed(2);

    tp.setANKFont(AS289R2::ANK_8x16);
    tp.printf("8x16: Test 012345 ｱｲｳｴｵ\r\r");
    tp.setANKFont(AS289R2::ANK_12x24);
    tp.printf("12x24: Test 012345 ｱｲｳｴｵ\r\r");
    tp.setANKFont(AS289R2::ANK_16x16);
    tp.printf("16x16: Test 012345 ｱｲｳｴｵ\r\r");
    tp.setANKFont(AS289R2::ANK_24x24);
    tp.printf("24x24: Test 012345 ｱｲｳｴｵ\r\r");
    tp.putLineFeed(1);

    tp.setANKFont(AS289R2::ANK_8x16);
    tp.printf("QR\r");
    tp.printQRCode(AS289R2::QR_ERR_LVL_M, url);
    tp.printf("\r%s\r", url);
    tp.putLineFeed(2);

    tp.printf("UPC-A\r");
    tp.printBarCode(AS289R2::BCODE_UPC_A, "01234567890");
    tp.putLineFeed(4);

    pc.printf("AS-289R2 thermal printer shield test\n\n");
    while(1) {
        if (pc.readable()) {
            int c = pc.getc();
            pc.putc(c);
            tp.putc(c);
        }
    }

}
