/*
 Demo of Embedded Artists LPCXpresso baseboard SD card and ethernet facilities.

 This program downloads three .wav files from a website to the SD card.

 SD Card setup:

 1. Insert all five jumpers in J39 as described in section 4.3.3
 of base board users guide.

 2. Remove jumper marked "A" in J55 In order to connect PIO1_11
 to CS signal of J40 (the SPI-SSEL signal)  as described in section 4.3.3
 of base board users guide.

 Now uses the HTTPClient from http://mbed.org/users/donatien/programs/HTTPClient/latest
 which downloads the files without errors.

*/
#include "mbed.h"
#include "SDHCFileSystem.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"

DigitalOut led1(LED1);// blinks when all done
DigitalOut led4(LED4);// blinks during file download

EthernetNetIf eth;
HTTPClient http;

Ticker tick;

//SDFileSystem sd(p5, p6, p7, p8, "sd");//mbed Workshop BOB
SDFileSystem sd(p5, p6, p7, p24, "sd");//EA baseboard mosi, miso, sclk, CS, name

void blinkLED4() {//blinks led4 during download
    led4 = !led4;
}

void downloadFileToSD(char *url, char *path) {

    HTTPFile httpfile(path);

    printf("Downloading to ");
    printf("%s", path);
    printf(" please wait ... \r\n");

    tick.attach(& blinkLED4, 0.5);

    HTTPResult result = http.get(url, &httpfile);

    if (result == HTTP_OK) {
        printf("File downloaded OK\r\n");
    } else {
        printf("Error during download %d\r\n", result);
    }

    tick.detach();

    led4 = 0;
}

int main() {

    printf("Connecting to network ...\r\n");
    EthernetErr ethErr = eth.setup();
    if (ethErr) {
        printf("Error %d in setup.\r\n", ethErr);
        return -1;
    }
    printf("Network interface is up\r\n");

    
    printf("\r\n----------- Starting download ------------\r\n");

    downloadFileToSD("http://homepage.ntlworld.com/green_bean/mbed/bong.wav", "/sd/bong.wav" );
    downloadFileToSD("http://homepage.ntlworld.com/green_bean/mbed/quarter.wav", "/sd/quarter.wav" );
    downloadFileToSD("http://homepage.ntlworld.com/green_bean/mbed/hour.wav", "/sd/hour.wav" );

    printf("-------------- All done ------------\r\n");

    while (1) {
        led1 = !led1;
        wait(0.2);
    }

}
