#include "mbed.h"
#include "USBKeyboard.h"

//LED1: NUM_LOCK
//LED2: CAPS_LOCK
//LED3: SCROLL_LOCK
Serial pc(USBTX, USBRX);        // PC モニタ
Serial uart(p9, p10);           // UART
//BusOut leds(LED1, LED2, LED3);
USBKeyboard keyboard;           // USBキーボード
DigitalOut led4(LED4);

char buffer[256];   // 受信バッファ
unsigned char indexW = 0;     // 書込インデックス
unsigned char indexR = 0;     // 読出インデックス

///
/// UART受信割込み
///
void uartRxIrq()
{
    while (uart.readable()) {
        buffer[indexW] = uart.getc();
        indexW++;
    }

    /*
    keyboard.mediaControl(KEY_VOLUME_DOWN);
    keyboard.printf("Hello World from Mbed\r\n");
    keyboard.keyCode('s', KEY_CTRL);
    keyboard.keyCode(KEY_CAPS_LOCK);
    //leds = keyboard.lockStatus();
    */
}

// FF14楽器演奏キー
char ffKey[] = {
    'a', '1',   // ド    48
    'b', '2',   // レ
    'c',        // ミ
    'd', '3',   // ファ
    'e', '4',   // ソ
    'f', '5',   // ラ
    'g',        // シ    59
    'h', '6',   // ド    60
    'i', '7',   // レ
    'j',        // ミ
    'k', '8',   // ファ
    'l', '9',   // ソ
    'm', '0',   // ラ
    'n',        // シ    71
    'o', 'w',   // ド    72
    'p', 'x',   // レ
    'q',        // ミ
    'r', 'y',   // ファ
    's', 'z',   // ソ
    't', '.',   // ラ
    'u',        // シ
    'v',        // ド    84
    ',', '/', ';', '[', ']'
};

///
/// メイン
///
int main(void)
{
    led4 = 1;
    uart.baud(115200);  // UARTボーレート
    pc.baud(115200);    // PCモニタ通信ボーレート
    uart.attach(uartRxIrq, Serial::RxIrq);    // 受信割り込みの設定

    pc.printf("MIDI Keyboard Converter for FF14 and PS4\r\n");

    // 無限ループ
    while (1) {
        // 先頭が'O'でないなら読み飛ばす。
        while ((indexR != indexW) && (buffer[indexR] != 'O' )) {
            pc.printf("skip &c", buffer[indexR]);
            indexR++;
        }
        // 先頭が'O'で4文字以上受信済みかチェック
        if (((unsigned char)(indexW - indexR) >= 4) && (buffer[indexR] == 'O')) {
            int key = (buffer[indexR + 2] - '0') * 10 + (buffer[indexR + 3] - '0');
            switch(buffer[indexR + 1]) {
                case 'N':
                    if (key < 48 || key > 84) {
                        pc.printf("reject %d", key);
                        break;    // 48未満と84超過は対象外
                    }
                    key -= 48;
                    keyboard.keyDown(ffKey[key]);
                    //keyboard.printf("%c", ffKey[key]);
                    break;
                case 'F':
                    if (key < 48 || key > 84) {
                        pc.printf("reject %d", key);
                        break;    // 48未満と84超過は対象外
                    }
                    key -= 48;
                    keyboard.keyUp(ffKey[key]);
                    break;
                default:
                    pc.printf("不正なコードの受信 %c", buffer[indexR + 1]);
                    break;
            }
            indexR += 4;
            led4 = !led4;
        }
    }
}