#include "mbed.h"
#include "USBHostMIDI.h"

Serial pc(USBTX, USBRX);    // デバッグ用モニタ通信
Serial uart(p9, p10);       // UART
DigitalOut led(LED1);       // 基板上LED
RawSerial  midi(p28, NC);   // この用途では不要

///
/// MIDI Note OFF イベント
///
void onMidNoteOff   (uint8_t ch, uint8_t  key, uint8_t vel) { 
    uart.printf("OF%2d", key);  // キーOFFをUARTで送信。
    //midi.putc(0x80|ch); midi.putc(key); midi.putc(vel); 
    led = !led; 
    pc.printf("NoteOff ch= %d, key= %d, vel= %d\r\n", ch, key, vel);
}

///
/// MIDI Note ONイベント
///
void onMidNoteOn    (uint8_t ch, uint8_t  key, uint8_t vel) {
    uart.printf("ON%2d", key);  // キーOFFをUARTで送信。
    //midi.putc(0x90|ch); midi.putc(key); midi.putc(vel); 
    led = !led; 
    pc.printf("NoteOn ch= %d, key= %d, vel= %d\r\n", ch, key, vel);
}

///
/// MIDI コントロールチェンジイベント
///
void onMidCtrlChg   (uint8_t ch, uint8_t   cc, uint8_t val) { 
    //midi.putc(0xB0|ch); 
    //midi.putc(cc); 
    //midi.putc(val); 
}

///
/// MIDI ピッチベンドイベント
///
void onMidPitchBend (uint8_t ch, uint16_t val)              { 
    //midi.putc(0xE0|ch); 
    //midi.putc(val&0x7F); 
    //midi.putc(val>>7); 
}

void onMidExclusive (uint8_t*, uint16_t, bool)  {}

void onMid1byte     (uint8_t)                   {}

void onMid2bytes    (uint8_t, uint8_t)          {}

void onMid3bytes    (uint8_t, uint8_t, uint8_t) {}

///
/// mid_taskスレッド
///
void mid_task(void const *) {
    USBHostMIDI mid;
    mid.attachNoteOff                   (onMidNoteOff   ); mid.attachNoteOn         (onMidNoteOn    );
    mid.attachPolyKeyPress              (onMid3bytes    ); mid.attachControlChange  (onMidCtrlChg   );
    mid.attachProgramChange             (onMid2bytes    ); mid.attachChannelPressure(onMid2bytes    );
    mid.attachPitchBend                 (onMidPitchBend ); mid.attachSystemExclusive(onMidExclusive );
    mid.attachSystemCommonTwoBytes      (onMid2bytes    ); mid.attachSingleByte     (onMid1byte     );
    mid.attachSystemCommonThreeBytes    (onMid3bytes    ); mid.attachCableEvent     (onMid3bytes    );
    mid.attachMiscellaneousFunctionCode (onMid3bytes    );
    for(;;) { while(!mid.connect())  { Thread::wait(250); } led = 1;
              while(mid.connected()) { Thread::wait(250); } led = 0; }
}

int main() {
    pc.baud(115200);    // モニタのボーレート
    uart.baud(115200);  // UARTのボーレート
    midi.baud(31250); 
    DigitalOut hoge(P2_9); hoge = 1; // disable usb d+ pullup
    // MIDIタスクスレッドの起動
    Thread midTask(mid_task, NULL, osPriorityNormal, 1024);
    const char aMsg[] = "\xF0\x43\x79\x09\x00\x50\x10" "j M,M,e,s M,b' i,i\0" "\xF7";
    Thread::wait(3500);
    for(int i = 0; i < sizeof(aMsg)-1; midi.putc(aMsg[i++]));
    // 無限ループ
    for(;;) { Thread::wait(250); }
}