#ifndef MAX_DISTANCE_RESOURCE_H
#define MAX_DISTANCE_RESOURCE_H

#include "DynamicResource.h"
#include "hcsr04.h"

class MaxDistanceResource : public DynamicResource {
public:
    MaxDistanceResource(const Logger *logger, const char *name, HCSR04 *sensor, const bool observable = false)
     : DynamicResource(logger, name, "MaxDistanceResource", SN_GRS_GET_ALLOWED, observable), sensor(sensor)
    {}
    
    virtual string get()
    {
        char buf[10];
        snprintf(buf, 10, "%0.2f", sensor->get_max_dist_cm());
        return string(buf);
    }
private:
    HCSR04 *sensor;
};

#endif