#include "mbed.h"
#include "EthernetInterface.h"
#include "ConnectorEndpoint.h"
#include "OptionsBuilder.h"

#include "hcsr04.h"
#include "GroveTemp.h"

#include "StaticResource.h"
//#include "OnBoardLED.h"
#include "TemperatureResource.h"
#include "DistanceResource.h"
#include "MaxDistanceResource.h"

/* Terminal connection */
RawSerial term(USBTX, USBRX);
Logger logger(&term);

/* Sensors */
#define TRIG_PIN D6
#define ECHO_PIN D5
HCSR04 distS(TRIG_PIN, ECHO_PIN); 
GroveTempSensor tempS;

/* Resources */
StaticResource mfg(&logger, "3/0/0", "Freescale");
StaticResource model(&logger, "3/0/1", "K64F mbed Ethernet demo");

StaticResource latitude(&logger, "6/0/0", "35.296");
StaticResource longitude(&logger, "6/0/1", "-120.677");

DistanceResource distR(&logger, "3302/0/5700", &distS, true);
MaxDistanceResource maxDistR(&logger, "3302/0/5602", &distS, true);
StaticResource unitsDistR(&logger, "3302/0/5701", "cm");

TemperatureResource tempR(&logger, "3303/0/5700", &tempS, true);
StaticResource unitsTempR(&logger, "3302/0/5701", "Cel");

//LEDResource led(&logger, "3311/1/5706");

/* invoked through linker magic via Endpoint::start() */
Connector::Options *configure_endpoint(Connector::OptionsBuilder &config)
{
    /* NSP configuration is in nsp_configuration.h */
    logger.log("configure_endpoint: building endpoint configuration...");
    tempR.setMaxAge(5);
    distR.setMaxAge(15);
    return config.addResource(&mfg)
                 .addResource(&model)
                 .addResource(&latitude)
                 .addResource(&longitude)
                 .addResource(&distR)
                 .addResource(&maxDistR)
                 .addResource(&unitsDistR)
                 .addResource(&tempR)
                 .addResource(&unitsTempR)
                 //.addResource(&led)
                 .build();
}

int main() {
   logger.log("\r\n\r\nSmart Trash Can booting\r\n");
   Connector::Endpoint::plumbNetwork();
   Connector::Endpoint::start();
}
