#include "mbed.h"
#include <math.h>
#include "GroveTemp.h"
//
AnalogIn thermistor(A0);   /* Temperature sensor connected to Analog Grove connector */

GroveTempSensor::GroveTempSensor() {
   resetMinMax();
}

float GroveTempSensor::getTemp() {
   unsigned int analogRead;
//                units, 
//                tens;
    
   analogRead = thermistor.read_u16(); /* Read analog value */
   
   /* Calculate the resistance of the thermistor from analog votage read. */
   resistance = (float) 10000.0 * ((65536.0 / analogRead) - 1.0);

   /* Convert the resistance to temperature using Steinhart's Hart equation */
   temperature = (1/((log(resistance/10000.0)/TEMP_BETA) + (1.0/298.15)))-273.15; 

//   units = (int) temperature % 10;
//   tens  = (int) temperature / 10;
   if (temperature > maxTemp)
      maxTemp = temperature;
   if (temperature < minTemp)
      minTemp = temperature;
   
   return temperature;
}

void GroveTempSensor::resetMinMax() {
   maxTemp = -999.9;
   minTemp = 999.9;
   minMaxDefined = false;
}

float GroveTempSensor::getMin() {
   if (!minMaxDefined)
      getTemp();
   return minTemp;
}

float GroveTempSensor::getMax() {
   if (!minMaxDefined)
      getTemp();
   return maxTemp;
}