#include "mbed.h"
#include "Songs.h"

Serial sTerm(USBTX, USBRX);

Song::Song() {
   choose("rain");
}
   
Song::Song(char *choice) {
   choose(choice);
}
   
void Song::play() {
   
   for(int i = 0; i < length; i++) {
      if(notes[i] == ' ') {
         wait_us(beats[i] * tempo * 1000);
      } else {
         playNote(notes[i], range[i], beats[i] * tempo);
      }
      wait_us(betweenWait);    /* delay between notes */
   }
}
   
void Song::choose(char *choice) {
   
   if (!strcmp(choice, "sun")) {
      int beatsRef[] = {2,4,4,5,2,2,2,5,4,2,4,4,8,1,2,4,4,1,4,4,4,4};
      notes =          "CbCaCabC CbCa aba Cba ";
      int rangeRef[] = {6,5,6,5,6,5,5,6,0,6,5,6,5,0,5,5,5,0,6,5,5,0};
      tempo = 150;
      betweenWait = 1;
      length = sizeof(beatsRef) / sizeof(beatsRef[0]);
      for (int i = 0; i < length; ++i) {
         beats[i] = beatsRef[i];
         range[i] = rangeRef[i];
      }
   }
   else if (!strcmp(choice, "william")) {
      int beatsRef[] = {1,1,2,1,1,2,1,1,2,2,2,1,1,2,1,1,2,1,1,2,2,2,1,1,2,1,1,2,1,1,2,2,2,1,1,5,1,1,1,2,2,2,4};
      notes =          "ddddddddgabdddddgbbaFdddddddddgabgbdcbagbg ";
      int rangeRef[] = {5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,5,5,5,5,5,0};
      tempo = 90;
      betweenWait = 20000;
      length = sizeof(beatsRef) / sizeof(beatsRef[0]);
      for (int i = 0; i < length; ++i) {
         beats[i] = beatsRef[i];
         range[i] = rangeRef[i];
      }
   }
   else if (!strcmp(choice, "circus")) {
      int beatsRef[] = {2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4};
      notes =          "cCdDefFgGaAbcCdDefFgGaAbcCdDefFgGaAbc ";
      int rangeRef[] = {4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,7,0};
      tempo = 50;
      betweenWait = 1;
      length = sizeof(beatsRef) / sizeof(beatsRef[0]);
      for (int i = 0; i < length; ++i) {
         beats[i] = beatsRef[i];
         range[i] = rangeRef[i];
      }
   }
   else {       //rain
      int beatsRef[] = {4,2,4,2,4,2,4,2,4,2,3,1,2,2,2,2,2,2,2,4};
      notes =          "ecdbcabgacbcdecdbca ";
      int rangeRef[] = {6,6,6,5,6,5,5,5,5,6,5,6,6,6,6,6,5,6,5,0};
      tempo = 120;
      betweenWait = 1;
      length = sizeof(beatsRef) / sizeof(beatsRef[0]);
      for (int i = 0; i < length; ++i) {
         beats[i] = beatsRef[i];
         range[i] = rangeRef[i];
      }
   }
}
   
void Song::setTempo(int setT) {
   tempo = setT;
}


