#include "Buzzer.h"


/*
  Buzzer
 The example use a buzzer to play melodies. It sends a square wave of the 
 appropriate frequency to the buzzer, generating the corresponding tone.
 
 The circuit:
 * Buzzer attached to pin39 (J14 plug on Grove Base BoosterPack)
 * one side pin (either one) to ground
 * the other side pin to VCC
 * LED anode (long leg) attached to RED_LED
 * LED cathode (short leg) attached to ground
 
 * Note:  
 
 
 This example code is in the public domain.
 
 http://www.seeedstudio.com/wiki/index.php?title=GROVE_-_Starter_Kit_v1.1b#Grove_-_Buzzer
 
*/
static DigitalOut Buzzer(BUZZER_PIN);

/* play tone */
void playTone(int tone, int duration) {
  for (long i = 0; i < duration * 1000L; i += tone * 2) {
    Buzzer = 1;
    wait_us(tone);
    Buzzer = 0;
    wait_us(tone);
  }
}

void playNote(char note, int range, int duration) {
   int cTones[] = { 3822, 1911, 956, 478};
   int CTones[] = { 3608, 1803, 902 };
   int dTones[] = { 3405, 1702, 851 };
   int DTones[] = { 3214, 1607, 803 };
   int eTones[] = { 3034, 1517, 758 };
   int fTones[] = { 2863, 1432, 716 };
   int FTones[] = { 2702, 1351, 675 };
   int gTones[] = { 2551, 1275, 638 };
   int GTones[] = { 2408, 1204, 602 };
   int aTones[] = { 2273, 1136, 568 };
   int ATones[] = { 2145, 1072, 536 };
   int bTones[] = { 2025, 1013, 506 };
  
   // play the tone corresponding to the note name
   switch (note) {
   case 'a':
      playTone(aTones[range - RANGE_OFFSET], duration);
      break;
   
   case 'A':
      playTone(ATones[range - RANGE_OFFSET], duration);
      break;
   
   case 'b':
      playTone(bTones[range - RANGE_OFFSET], duration);
      break;
   
   case 'c':
      playTone(cTones[range - RANGE_OFFSET], duration);
      break;
   
   case 'C':
      playTone(CTones[range - RANGE_OFFSET], duration);
      break;
   
   case 'd':
      playTone(dTones[range - RANGE_OFFSET], duration);
      break;
   
   case 'D':
      playTone(DTones[range - RANGE_OFFSET], duration);
      break;
   
   case 'e':
      playTone(eTones[range - RANGE_OFFSET], duration);
      break;

   case 'f':
      playTone(fTones[range - RANGE_OFFSET], duration);
      break;
   
   case 'F':
      playTone(FTones[range - RANGE_OFFSET], duration);
      break;
   
   case 'g':
      playTone(gTones[range - RANGE_OFFSET], duration);
      break;
   
   case 'G': 
      playTone(GTones[range - RANGE_OFFSET], duration);
      break;
   
   default:
      playTone(cTones[0], duration);
  }
}