/*
  Test for manual control thread
  Spektrum receiver simple test

  range on transmitter is 344-1564
  to correspond to rudder angle of 90-270
  current eqn to convert RC output is

            (IN/6.77)+39.19

  NB: The specification for Spektrum Remote Receiver Interfacing,
  rev A, 12 Apr 2016, has a note about servo position ranges:
  "A full range of servo position data ranges from 0-1024 or 0-2045 depending
  on the bind type. These limits are equivalent to a +/-150% travel setting
  in AirWare. This full range translates to a range of 1194us which when
  applied to a pwm servo signal equals 903-2097us. At +/-100% travel, the
  data range is equivalent to a servo position data range of approximately
  341 to 1707 which translated to pwm equals 1102 us to 1898 us."
*/

#include "mbed.h"
//#include "rtos.h"
#include "Spektrum.h"
#include "unity.h"
//****RC control universal variables****
Serial pc(USBTX, USBRX, 115200);
Spektrum rx(p13, p14);
char c;
int i;
int j;
float now;
//***Stepper Motor universal variables***
AnalogIn   r_ain(p18);
PwmOut  rudder( p22 );
DigitalOut   r_dir( p21 );
DigitalOut    r_I(p23);
DigitalOut r_slp(p30); //sleep
float r_ang = 180.0;
float r_pos = 180.0;
float RC_1;

//**get position**
float posr();


int main(void)
{

    r_I=0;
    rudder.period(.001);
    rudder.pulsewidth(0);
    // loop
    while(1) {
        //now = rtos::Kernel::get_ms_count();
        //***JUST ADDED stepper code

        if (rx.valid) {
            RC_1 = rx.channel[0];
            pc.printf(" rc: %f\n",rx.channel[0]);
        } else {
            pc.printf(" invalid\r\n");
            r_slp = 0;
        }
        //39.19
        r_ang = (RC_1/6.77)+39.19;

        r_pos = (r_ain-.108)/.002466;
        //pc.printf(" %.3f\n",);
        if((r_pos > (r_ang-3.0)) && (r_pos < (r_ang+3.0))) {
            rudder.pulsewidth(0);
            r_slp = 0;
        }
        if( (r_pos > (r_ang+3.0)) && r_pos < 270.0) {
            r_slp = 1;
            while(r_pos > r_ang) {
                r_dir = 1; //left??
                rudder.pulsewidth(.0005);
                pc.printf("pos: %.3f\n",r_pos);
                r_pos = posr();
            }//while pos
            rudder.pulsewidth(0);
        }//if pos
        if((r_pos < (r_ang-3.0)) && r_pos > 90.0) {
            r_slp = 1;
            while(r_pos < r_ang) {
                r_dir = 0; //right??
                rudder.pulsewidth(.0005);
                pc.printf("pos: %.3f\n",r_pos);
                r_pos = posr();
            }//while pos
            rudder.pulsewidth(0);
        }
        //***END OF JUST ADDED
        ThisThread::sleep_until(121);
    }//while(1)
} // main() for TESTS/receiver/simple



float posr()
{
    float r1;
    float r2;
    float r3;
    r1 = (r_ain-.108)/.002466;
    r2 = (r_ain-.108)/.002466;
    r3 = (r_ain-.108)/.002466;
    return (r1+r2+r3)/3.0;
}
