/*
  Test for manual control thread
  Spektrum receiver simple test

  range on transmitter is 344-1564
  to correspond to rudder angle of 90-270
  current eqn to convert RC output is

            (IN/6.77)+39.19

  NB: The specification for Spektrum Remote Receiver Interfacing,
  rev A, 12 Apr 2016, has a note about servo position ranges:
  "A full range of servo position data ranges from 0-1024 or 0-2045 depending
  on the bind type. These limits are equivalent to a +/-150% travel setting
  in AirWare. This full range translates to a range of 1194us which when
  applied to a pwm servo signal equals 903-2097us. At +/-100% travel, the
  data range is equivalent to a servo position data range of approximately
  341 to 1707 which translated to pwm equals 1102 us to 1898 us."
*/

#include "mbed.h"
//#include "rtos.h"
#include "Spektrum.h"
#include "unity.h"
//****RC control universal variables****
Serial pc(USBTX, USBRX, 115200);
Spektrum rx(p13, p14);
char c;
int i;
int j;
float now;
//***Stepper Motor universal variables***
AnalogIn   ain(p20);
PwmOut  motor( p25 );
DigitalOut   dir( p24 );
DigitalOut    I(p26);
DigitalOut slp(p29); //sleep
float d_ang = 180.0;
float pos = 180.0;
float RC_O;

//**get position**
float posi(float in);


int main(void)
{

    I=0;
    motor.period(.001);
    motor.pulsewidth(0);
    // loop
    while(1) {
        //now = rtos::Kernel::get_ms_count();
        //***JUST ADDED stepper code

        if (rx.valid) {
            RC_O = rx.channel[0];
            pc.printf(" rc: %f\n",rx.channel[0]);
        } else {
            pc.printf(" invalid\r\n");
            slp = 0;
        }
        //39.19
        d_ang = (RC_O/6.77)+39.19;

        pos = (ain-.108)/.002466;
        //pc.printf(" %.3f\n",);
        if((pos > (d_ang-3.0)) && (pos < (d_ang+3.0))) {
            motor.pulsewidth(0);
            slp = 0;
        }
        if( (pos > (d_ang+3.0)) && pos < 270.0) {
            slp = 1;
            while(pos > d_ang) {
                dir = 1; //left??
                motor.pulsewidth(.0005);
                pc.printf("pos: %.3f\n",pos);
                pos = posi(ain);
            }//while pos
            motor.pulsewidth(0);
        }//if pos
        if((pos < (d_ang-3.0)) && pos > 90.0) {
            slp = 1;
            while(pos < d_ang) {
                dir = 0; //right??
                motor.pulsewidth(.0005);
                pc.printf("pos: %.3f\n",pos);
                pos = posi(ain);
            }//while pos
            motor.pulsewidth(0);
        }
        //***END OF JUST ADDED
        ThisThread::sleep_until(121);
    }//while(1)
} // main() for TESTS/receiver/simple



float posi(float in)
{
    float p1;
    float p2;
    float p3;
    p1 = (ain-.108)/.002466;
    p2 = (ain-.108)/.002466;
    p3 = (ain-.108)/.002466;
    return (p1+p2+p3)/3.0;
}
