// Program to test the CAN bus using pins 29 and 30 on the mbed connected
// to an MCP2551 CAN transceiver bus IC
//  Note that this program will only continue to transmit while the TX message is <= 8 bytes long

#include "mbed.h"

#define RUDDER_ID     1   //Address of this CAN device
#define BNO_ID     2  //Address of Control CAN device
#define TELE_ID     3
#define RC_ID     4

Serial pc(USBTX, USBRX);    //tx, and rx for tera term
DigitalOut led1(LED1);      //heartbeat
DigitalOut led2(LED2);      //CAN read activity
DigitalOut led3(LED3);      //CAN write activity
DigitalOut led4(LED4);
CAN can(p30,p29);      //CAN interface


Ticker pulse;

float BNOangle;
float RC_out;
char datastr[20];
CANMessage msg_read;
float ff = 1.0;

float data; //telemetry data transmition

float CanValue()
{
    strcpy(datastr, (char*)msg_read.data+1);
    float value = strtod(datastr,NULL);
    return value;
}

//void alive(void)
//{
//    led1 = !led1;
//   if(led1)
//       pulse.attach(&alive, .2); // the address of the function to be attached (flip) and the interval (2 seconds)
//   else
//       pulse.attach(&alive, 1.3); // the address of the function to be attached (flip) and the interval (2 seconds)
//}
void Time_Read();
void Lat_Read();
void Long_Read();
void Bno_Read();
void Rudder_Read();
void Mast_Read();


int main()
{

    Thread::wait(200);

    // pulse.attach(&alive, 2.0); // the address of the function to be attached (alive) and the interval (2 seconds)
    can.frequency(500000);
    pc.baud(115200);

    pc.printf("%s\r\n", __FILE__);

    while(1) {
        //while(msg_read.data[0] != 'm' || msg_read.data[0] != 'M') {Thread::wait(ff);}
        //Time_Read();

        //while(msg_read.data[0] != 'm' || msg_read.data[0] != 'M') {Thread::wait(ff);}
        //Lat_Read();

        //while(msg_read.data[0] != 'm' || msg_read.data[0] != 'M') {Thread::wait(ff);}
        //Long_Read();

        //while(msg_read.data[0] != 'b' || msg_read.data[0] != 'B') {Thread::wait(ff);}
        Bno_Read();

        //while(msg_read.data[0] != 'r' || msg_read.data[0] != 'R') {Thread::wait(ff);}
        Rudder_Read();

        //while(msg_read.data[0] != 'm' || msg_read.data[0] != 'M') {Thread::wait(ff);}
        Mast_Read();

    }


}//main


void Bno_Read()
{

    while(can.read(msg_read)) { //if message is available, read into msg

        if(msg_read.id == BNO_ID) {   //if its the BNO ID

            if(msg_read.data[0] == 'b' || msg_read.data[0] == 'B') {

                led1 = !led1;
                BNOangle = CanValue();
                //data = BNOangle;       //a similar form of the code everywhere
                //myFloat.m_float = data;
                //data = myFloat.m_float;   // get the float back from the union
                pc.printf("BNO: %.1f", BNOangle); //data);

            }//if the first letter was an 's', it is a servo command
        }   //was the message to this device?

    }//while a CAN message has been read
    //return datastr;

}

void Lat_Read()
{

    while(can.read(msg_read)) { //if message is available, read into msg

        if(msg_read.id == BNO_ID) {   //if its the BNO ID

            if(msg_read.data[0] == 'L' || msg_read.data[0] == 'l') {

                //led2 = !led2;
                BNOangle = CanValue();
                //data = BNOangle;       //a similar form of the code everywhere
                //myFloat.m_float = data;
                //data = myFloat.m_float;   // get the float back from the union
                pc.printf("Lat: %.1f", BNOangle); //data);
                //Thread::wait(ff);
            }//if the first letter was an 's', it is a servo command
        }   //was the message to this device?
    }//while a CAN message has been read
    //return datastr;

}

void Long_Read()
{

    while(can.read(msg_read)) { //if message is available, read into msg

        //if(msg_read.id == BNO_ID) {   //if its the BNO ID

        if(msg_read.data[0] == 'O' || msg_read.data[0] == 'o') {

            //led2 = !led2;
            BNOangle = CanValue();
            //data = BNOangle;       //a similar form of the code everywhere
            //myFloat.m_float = data;
            //data = myFloat.m_float;   // get the float back from the union
            pc.printf("Long: %.1f", BNOangle); //data);
            //Thread::wait(ff);
        }//if the first letter was an 's', it is a servo command
        //}   //was the message to this device?
    }//while a CAN message has been read
    //return datastr;

}

void Time_Read()
{
    float time;
    while(can.read(msg_read)) { //if message is available, read into msg

        //if(msg_read.id == BNO_ID) {   //if its the BNO ID

        if(msg_read.data[0] == 't' || msg_read.data[0] == 'T') {

            led2 = !led2;
            time = CanValue();
            //data = BNOangle;       //a similar form of the code everywhere
            //myFloat.m_float = data;
            //data = myFloat.m_float;   // get the float back from the union
            pc.printf("Time: %.1f", time); //data);
            //Thread::wait(ff);
        }//if the first letter was an 's', it is a servo command
        // }   //was the message to this device?
    }//while a CAN message has been read
    //return datastr;

}

void Rudder_Read()
{

    while(can.read(msg_read)) { //if message is available, read into msg
        //if(msg_read.id == RC_ID) {   //if its the BNO ID
        if(msg_read.data[0] == 'r' || msg_read.data[0] == 'R') {
            led3 = !led3;
            RC_out = CanValue(); //I know this is redundant but i use
            //data = RC_out;       //a similar form of the code everywhere
            //myFloat.m_float = data;
            //data = myFloat.m_float;   // get the float back from the union
            pc.printf("Rudder: %.1f", RC_out); //data);
            //Thread::wait(ff);
        }//if the first letter was an 's', it is a servo command
        // }   //was the message to this device?
    }//while a CAN message has been read
    //return datastr;

}

void Mast_Read()
{

    while(can.read(msg_read)) { //if message is available, read into msg
        // if(msg_read.id == RC_ID) {   //if its the BNO ID
        if(msg_read.data[0] == 'm' || msg_read.data[0] == 'M') {
            led4 = !led4;
            RC_out = CanValue(); //I know this is redundant but i use
            //data = RC_out;       //a similar form of the code everywhere
            //myFloat.m_float = data;
            //data = myFloat.m_float;   // get the float back from the union
            pc.printf("Mast: %.1f\n", RC_out); //data);
            //Thread::wait(ff);
        }//if the first letter was an 's', it is a servo command
        //}   //was the message to this device?
    }//while a CAN message has been read
    //return datastr;

}