// Program to test the CAN bus using pins 29 and 30 on the mbed connected
// to an MCP2551 CAN transceiver bus IC
//  Note that this program will only continue to transmit while the TX message is <= 8 bytes long

#include "mbed.h"

#define RUDDER_ID     1   //Address of this CAN device
#define BNO_ID     2  //Address of Control CAN device
#define TELE_ID     3 
#define RC_ID     4 

Serial pc(USBTX, USBRX);    //tx, and rx for tera term
DigitalOut led1(LED1);      //heartbeat
DigitalOut led2(LED2);      //CAN read activity
DigitalOut led3(LED3);      //CAN write activity

CAN can(p30,p29);      //CAN interface


Ticker pulse;

float BNOangle;
float RC_out;
float RCval;
char datastr[20];
CANMessage msg_read;

float CanValue(){ 
    strcpy(datastr, (char*)msg_read.data+1); 
    float value = strtod(datastr,NULL);
    return value;      
}

void alive(void){
    led1 = !led1;
    if(led1)
        pulse.attach(&alive, .2); // the address of the function to be attached (flip) and the interval (2 seconds)     
    else
        pulse.attach(&alive, 1.3); // the address of the function to be attached (flip) and the interval (2 seconds)
}


float RC_Read(){
        
        while(can.read(msg_read)){ //if message is available, read into msg
            if(msg_read.id == RC_ID){    //if its the BNO ID           
                if(msg_read.data[0] == 'r' || msg_read.data[0] == 'R'){
                    led3 = !led3;
                    RC_out = CanValue();
                    return RC_out;
                }//if the first letter was an 's', it is a servo command
            }   //was the message to this device?
        }//while a CAN message has been read                         
   //return datastr;

}

int main() {
    
    Thread::wait(200);
    
    pulse.attach(&alive, 2.0); // the address of the function to be attached (alive) and the interval (2 seconds)
    can.frequency(500000);
    pc.baud(115200);                
    
    pc.printf("%s\r\n", __FILE__);
    
    while(1){
         
        RCval = RC_Read();
        pc.printf("%.1f\n",RCval); 
        }
        
   
}//main