#include "mbed.h"

#define PI 3.14159

AnalogOut dacOutput(p18);   // Ausgangs Pin 18
Ticker valueTicker;
float voltageValues[100];   // 100 Punkte
int actualPoint;            // Aktueller Punkt
int outputMode = 4;         // 1 = Sägezahn, 2 = Rechteck, 3 = Sinus, 4 = Dreieck

void outputToDAC()
{
    dacOutput.write(voltageValues[actualPoint]);
    actualPoint++;
    if(actualPoint >= 100)
    {
        actualPoint = 0;
    }
}

int main()
{
    actualPoint = 0;
    
    for(int i = 0; i < 100; i++)
    {
        switch(outputMode)
        {
            case 1:
                voltageValues[i] = (float)i / 100.f;;
                break;
            case 2:
                voltageValues[i] = i <= 49 ? 1 : 0;
                break;
            case 3:
                voltageValues[i] = 0.5f * sin(((float)i * PI) * 3.6f / 180) + 0.5f; // w = 6283 = 2 * PI * f
                break;
            case 4:
                voltageValues[i] = (i > 50 ? i * 2 - 100.f : 100.f - i * 2 ) / 100.f;
                break;
        }
    }
    
    valueTicker.attach_us(&outputToDAC, 10);
    
    while(1);
}
