#include "mbed.h"

Thread ledThread;
DigitalOut led(LED2);
Serial serialPC(USBTX, USBRX, 9600);
Mutex dutyCycleMutex;

const int period = 20; // ms
int dutyCycle = 50; // %


void ledOutput()
{
    while(true)
    {
        if(dutyCycle != 0)
        {
            dutyCycleMutex.lock();
            float onTime = (dutyCycle / 100.0f) * period;
            dutyCycleMutex.unlock();
            
            led = 1;
            ThisThread::sleep_for(onTime);
            led = 0;
            ThisThread::sleep_for(period - onTime);
        }
    }
}

int main()
{
    ledThread.start(ledOutput);
    
    while(true)
    {
        dutyCycleMutex.lock();
        serialPC.printf("Duty: %d\n", dutyCycle);
        dutyCycleMutex.unlock();
        char currentChar = serialPC.getc();
        
        if(currentChar == 'Z')
        {
            dutyCycleMutex.lock();
            dutyCycle = 0;
            dutyCycleMutex.unlock();
        }
        else if(currentChar >= '1' && currentChar <= '9')
        {
            dutyCycleMutex.lock();
            dutyCycle = (currentChar - '0') * 10;
            dutyCycleMutex.unlock();
        }
        else if(currentChar == 'F')
        {
            dutyCycleMutex.lock();
            dutyCycle = 100;
            dutyCycleMutex.unlock();
        }
    }
}
