#ifndef __SRF05_H__   //Inclusion safeguards
#define __SRF05_H__   //Definition of the inclusion
/*============================================================================*/

/* Libraries */
#include "mbed.h"                   // Mbed RTOS

/* Classes */
class SRF05
{
    public:
    SRF05(PinName TrigPin,PinName EchoPin);
    float get_dist(void);
    void start(void);
    
    private:
    DigitalOut   trigger;
    InterruptIn  echo;
    Timer        pulsetime;
    unsigned int pulsedur;
    float        distance;
    void isr_rise(void);
    void isr_fall(void);
};

/*============================================================================*/
#endif // End of inclusion