#include "SRF05.h"     // Contains Libraries, Definitions & Function Prototypes

// Constructor
SRF05::SRF05(PinName TrigPin,PinName EchoPin):
    trigger(TrigPin), echo(EchoPin)
{
    pulsetime.stop();
    pulsetime.reset();
    echo.rise(this,&SRF05::isr_rise);
    echo.fall(this,&SRF05::isr_fall);
    trigger = 0;
}

// Starting the sensor
void SRF05::start(void)
{
    trigger=1;
    wait_us(10);
    trigger=0;
}

// Return signal start
void SRF05::isr_rise(void)
{
    pulsetime.start();
}

// Return signal end
void SRF05::isr_fall(void)
{
    pulsetime.stop();
    pulsedur = pulsetime.read_us();
    distance = (pulsedur*343)/20000;
    distance = distance/100;
    pulsetime.reset();
}

// Get distance
float SRF05::get_dist()
{
    return distance;
}