#ifndef __PROJ515_H__ //Inclusion safeguards
#define __PROJ515_H__ //Definition of the inclusion
/*============================================================================*/

/* Libraries */
#include "mbed.h"                   // Mbed RTOS
#include "TinyGPSPlus.h"            // GPS Module Library
#include "ros.h"                    // ROS Library
#include "sensor_msgs/NavSatFix.h"  // ROS Sensor Messages component
#include "std_msgs/String.h"        // ROS Standard Messages component
//#include "std_msgs/Char.h"        // ROS Standard Messages component

/* Definitions */
#define LEDS_OFF 0x00               // LED bus all off
#define LEDS_ON  0x07               // LED bus all on
#define GPS_TX   PC_10              // GPS Transmit Pin
#define GPS_RX   PC_11              // GPS Recieve  Pin
#define USB_TX   PD_5               // USB Transmit Pin
#define USB_RX   PD_6               // USB Recieve  Pin

#define GPS_Baud 9600               // GPS Baud Rate
#define USB_Baud 9600               // USB Baud Rate
#define ROS_Baud 921600             // ROS Baud Rate
#define frameID "gps_odom"          // ROS frame ID

#define UNAGUMENTED  0x00           // Unagumented 
#define GPS_CONSTELL 0x01           // GPS constellation
#define UNNWN        0x00           // Unknown covariance

#define CVX 0x01                    // Covariance value for X from the datasheet
#define CVY 0x01                    // Covariance value for X from the datasheet
#define CVZ 0x01                    // Covariance value for X from the datasheet
#define CVO 0x00                    // Covariance value for zero components

#define PRINT_DATA 0x01             // Thread communication event to print data

/* Declarations */
extern char gps_c;                  // GPS stream character - Defined in PROJ515.cpp
extern int  sats_n;                 // GPS satelite number  - Defined in PROJ515.cpp    

/* Function prototypes */
void streamF();                     // Function prototype for streaming data
void setupRosMsg();                 // Function prototype for seting up ROS messages

/*============================================================================*/
#endif // End of inclusion