#ifndef __LED_H__ //Inclusion safeguards
#define __LED_H__ //Definition of the inclusion
/*============================================================================*/

/* Libraries */
#include "mbed.h"
#include "PololuLedStrip.h"
#include <string>
#include <ros.h>
#include <std_msgs/String.h>
#include <geometry_msgs/Twist.h>

/* Definitions */
#define LED_COUNT 30
#define LED_F_PIN PC_9  
#define LED_B_PIN PC_8
#define MaxVelocity 0.5f


/* Declarations */
extern rgb_color colors[];
int LEDBrightness;
float led_tmp;
int led_num;

extern string audio_state;
extern float vel;
extern float ang;


/* Instantiations */
PololuLedStrip ledStripFront(LED_F_PIN);
PololuLedStrip ledStripBack(LED_B_PIN);
ros::NodeHandle nh;
std_msgs::String status_msg;
ros::Publisher status_pub("status", &status_msg); 
ros::Subscriber<std_msgs::String> AudioStatus("audio_status", &AudioStatusCB);
ros::Subscriber<geometry_msgs::Twist> cmd_vel_sub("cmd_vel", &cmdVelCB);

/* Function Prototypes */
void AudioStatusCB(const std_msgs::String &status);
void cmdVelCB(const geometry_msgs::Twist &twist);
float Map(float x, float in_min, float in_max, float out_min, float out_max);

/*============================================================================*/
#endif // End of inclusion