#include "mbed.h"
#include "dateAndTime.hpp"

TDS_DT C_DT::getDT()            // Returns TDS_DT Date & Time format
{
    time_t secondsElapsed;      // Object of type time_t
    struct tm *tempTimeInfo;    // Pointer to a embeded structure containing calendar dates

    time(&secondsElapsed);      // Get time is seconds since epoch. Also hope people are ready for UNIX milenium bug
    tempTimeInfo = localtime (&secondsElapsed); // Convert current epoch time to calendar time acounting for timezones & daylight saving

    // Reasign date components to custom data type
    this-> date_time.day = tempTimeInfo->tm_mday;
    this-> date_time.mnt = 1+tempTimeInfo->tm_mon;      // Months indexed at 1
    this-> date_time.yr = 1900 + tempTimeInfo->tm_year; // Years since epoch

    // Reasign time components to custom data type
    this-> date_time.sec = tempTimeInfo->tm_sec;
    this-> date_time.min = tempTimeInfo->tm_min;
    this-> date_time.hr = tempTimeInfo->tm_hour;

    return date_time;   // Return custom data type containing Date & Time
}


void C_DT::setD(int day, int mnt, int yr)    // Updates RTC date
{
    time_t secondsElapsed;      // Object of type time_t
    struct tm *tempTimeInfo;    // Pointer to a embeded structure containing calendar dates

    time(&secondsElapsed);      // Get time is seconds since epoch.
    tempTimeInfo = localtime (&secondsElapsed); // Convert current epoch time to calendar time acounting for timezones & daylight saving

    tempTimeInfo->tm_mday = day;            // Update day
    tempTimeInfo->tm_mon  = mnt - 1;        // Update month / Indexed at 0
    tempTimeInfo->tm_year = yr - 1900 ;     // Update year  / Years since epoch

    secondsElapsed = mktime(tempTimeInfo);  // Convert to epoch time
    set_time(secondsElapsed);               // Update RTC
}


void C_DT::setT(int hr, int min, int sec)   // Updates RTC time
{
    time_t secondsElapsed;      // Object of type time_t
    struct tm *tempTimeInfo;    // Pointer to a embeded structure containing calendar dates

    time(&secondsElapsed);      // Get time is seconds since epoch.
    tempTimeInfo = localtime (&secondsElapsed); // Convert current epoch time to calendar time acounting for timezones & daylight saving

    tempTimeInfo->tm_sec = sec; // Update seconds
    tempTimeInfo->tm_min = min; // Update minutes
    tempTimeInfo->tm_hour = hr; // Update hours

    secondsElapsed = mktime(tempTimeInfo);  // Convert to epoch time
    set_time(secondsElapsed);               // Update RTC
}