#include "mbed.h"
#include <iostream>
#include "recordsMaster.hpp"

circularBuffer::circularBuffer()
{
    // Check allocated buffer size
    if (sizeof(record)/sizeof(TDS_record) == 120) {
        bufferLoopBack = 0;
        cerr <<"\n\rBuffer aquired\n\r\n"<<endl;
    } else {
        cerr << "Could not aquire buffer - bad length\n\r" << endl;
        cerr << "Attempted to aquire buffer of length 120\n\r" << endl;
        cerr << "Got buffer of " << sizeof(record)/sizeof(TDS_record) << "\n\r\n" << endl;
    }

    // Create blank record with all data = 0
    blankRecord.record_Data.temp   =  0;
    blankRecord.record_Data.pres   =  0;
    blankRecord.record_Data.ligt   =  0;
    blankRecord.record_DT.day      =  0;
    blankRecord.record_DT.mnt      =  0;
    blankRecord.record_DT.yr       =  0;
    blankRecord.record_DT.sec      =  0;
    blankRecord.record_DT.min      =  0;
    blankRecord.record_DT.hr       =  0;

}

int circularBuffer::write(TDS_record recordData)
{
    if (bufferLoopBack > 119) {
        bufferLoopBack = 0;       // Make circular
    }
    recordLock.lock();            // Lock for writing
    record[bufferLoopBack] = recordData;    // Store data temporarely
    bufferLoopBack++;             // Set next writing space
    recordLock.unlock();          // Unlock
    return 0;
}


int circularBuffer::read(int index)
{
    if (index == 0) {                 // If index is 0
        index = bufferLoopBack-1;     // Read last record
    } else {
        index--;                      // Scale form 1->120 to 0->119
    }
    if ((index <0)||(index >119)) {   // If reading outside of buffer range
        return -1;                    // Return fail

    } else {                          // Else
        recordLock.lock();            // Prevent unsynchronised reads
        TDS_record tempRecord = record[index];   // Store data temporarely
        recordLock.unlock();          // Unlock
        cout <<"\n\n\n\r Record number "<< index <<endl;
        cout <<"\n\r Date:" <<endl;
        cout <<"\r "<< tempRecord.record_DT.day <<"."<< tempRecord.record_DT.mnt <<"."<< tempRecord.record_DT.yr <<endl;
        cout <<"\n\r Time:" <<endl;
        cout <<"\r "<< tempRecord.record_DT.hr <<":"<< tempRecord.record_DT.min <<":"<< tempRecord.record_DT.sec <<endl;
        cout <<"\n\r Temperature = " << tempRecord.record_Data.temp <<endl;
        cout <<"\r Preassure = "   << tempRecord.record_Data.pres <<endl;
        cout <<"\r Light Level = " << tempRecord.record_Data.ligt <<endl;
        return 0;                     // Return sucess

    }
}


int circularBuffer::del(int index)
{
    index--;                          // Scale form 1->120 to 0->119
    if ((index <0)||(index >119)) {   // If reading outside of buffer range
        return -1;                    // Return fail
    } else {
        recordLock.lock();            // Lock for writing
        record[index] = blankRecord;  // Erase actual data, not just refference
        recordLock.unlock();          // Unlock
        return 0;                     // Return sucess
    }
}


int circularBuffer::readAll()
{
    TDS_record tempRecord;

    for (int i=bufferLoopBack; i <120; i++) {   // Read top part of buffer
        recordLock.lock();            // Prevent unsynchronised reads
        tempRecord = record[i];       // Store data temporarely
        recordLock.unlock();          // Unlock
        cout <<"\n\r Record number "<< i <<endl;
        cout <<"\n\r Date:" <<endl;
        cout <<"\n\r"<< tempRecord.record_DT.day <<"."<< tempRecord.record_DT.mnt <<"."<< tempRecord.record_DT.yr <<endl;
        cout <<"\n\r Time:" <<endl;
        cout <<"\n\r"<< tempRecord.record_DT.hr <<":"<< tempRecord.record_DT.min <<":"<< tempRecord.record_DT.sec <<endl;
        cout <<"\n\r Temperature = " << tempRecord.record_Data.temp <<endl;
        cout <<"\n\r Preassure = "   << tempRecord.record_Data.pres <<endl;
        cout <<"\n\r Light Level = " << tempRecord.record_Data.ligt <<endl;
    }

    for (int j=0; j <bufferLoopBack; j++) {   // Read bottom part of buffer
        recordLock.lock();            // Prevent unsynchronised reads
        tempRecord = record[j];       // Store data temporarely
        recordLock.unlock();          // Unlock
        cout <<"\n\r Record number "<< j <<endl;
        cout <<"\n\r Date:" <<endl;
        cout <<"\n\r"<< tempRecord.record_DT.day <<"."<< tempRecord.record_DT.mnt <<"."<< tempRecord.record_DT.yr <<endl;
        cout <<"\n\r Time:" <<endl;
        cout <<"\n\r"<< tempRecord.record_DT.hr <<":"<< tempRecord.record_DT.min <<":"<< tempRecord.record_DT.sec <<endl;
        cout <<"\n\r Temperature = " << tempRecord.record_Data.temp <<endl;
        cout <<"\n\r Preassure = "   << tempRecord.record_Data.pres <<endl;
        cout <<"\n\r Light Level = " << tempRecord.record_Data.ligt <<endl;
    }
    return 0;                         // Return sucess
}


int circularBuffer::delAll()
{
    for (int i=0; i <120; i++) {
        recordLock.lock();            // Lock for writing
        record[i] = blankRecord;      // Erase actual data, not just refference
        recordLock.unlock();          // Unlock
        bufferLoopBack = 0;           // Reset buffer
    }
    return 0;                         // Return sucess
}


int circularBuffer::recNum()
{
    return bufferLoopBack+1;          // Return last record number
}

circularBuffer::~circularBuffer()
{
    cerr << "Buffer Destroyed\n\r\n" << endl;
}