#ifndef displayMaster
#define displayMaster

#define defaultD1 D7    // Data Bus LSB
#define defaultD2 D6    // |
#define defaultD3 D4    // |
#define defaultD4 D2    // Data Bus MSB
#define defaultRS D9    // Register Select
#define defaultRW D0    // Read/Write Select
#define defaultEN D8    // Enable

/* Instructions on using the 16x2 LCD panel are found here:
[https://www.8051projects.net/lcd-interfacing/lcd-4-bit.php]                  */
/* N.B. I did the code from scratch since I do not have the code from ELEC230 */
/* N.B. This class contains blocking function so it goes into its own thread  */

// Custom 16x2 LCD display driver (4 bit mode only). Works via character stream
class C_displayMaster: public Stream 
{
protected:
    
    // Control line commands
    enum REGISTER {INSTRUCTION, DATA};
    enum MODE     {WRITE, READ};
    enum VALIDATE {DISABLE, ENABLE};

    // Control line types
    BusInOut      _commsBus;
    DigitalOut    _registerSel;
    DigitalOut    _modeSel;
    DigitalOut    _enable;
    
    // Private member variables
    int _col;                   // Cursor coloumn
    int _row;                   // Cursor row
    int _ADR;                   // Cursor DDRAM address 
    
    // Private member functions
    void writeChar(int, bool);  // Write character to display
    void busyCheck();           // Chek if the display is busy
    void calcDDRAM(int, int);   // Calculate address in DDRAm for row and coloumn
    
    virtual int _getc();        // Virtual reading function for character Stream (not needed by user so it is protected)
    
public:
    // Assign deafault pin names if they are not specified when constructor is run
    C_displayMaster(PinName D1 = defaultD1, PinName D2 = defaultD2, PinName D3 = defaultD3, PinName D4 = defaultD4, PinName RS = defaultRS, PinName RW = defaultRW, PinName EN = defaultEN);
   
    void clear();                 // Clear display
    virtual int _putc(int value); // Virtual writing function for character Stream 

};

#endif