#ifndef __samplingMaster__ //Inclusion safeguards
#define __samplingMaster__


typedef struct __attribute__ ((packed)) { // Store one after another

    float temp;     // Temperature
    float pres;     // Presure
    float ligt;     // Light level

} TDS_sensorData;   // Type Def Struct _ sensor Data


/* Spec said that we are not allowed to use any third party code unless it is
from ARM or STmicroelectronics, so I wrote my own driver for sampling BMP280 &
ADC in succesion. Ths code for MPB280 was inspired by the BMP280 Datasheet: 
[https://cdn-shop.adafruit.com/datasheets/BST-BMP280-DS001-11.pdf]
and BMP280 mbed library by "charlie": 
[https://os.mbed.com/users/charly/code/BMP280/] */




/* BMP280 register addresses and values */
#define I2C_adr 0xEE
#define CONTROL_REGISTER 0xF4
#define Tsb_IIR_REGISTER 0xF5
#define PRES_ADDRESS_VAL 0xF7
#define TEMP_ADDRESS_VAL 0xFA
#define DIG_Tn_REGISTERS 0x88
#define DIG_Pn_REGISTERS 0x8E
#define PREAS_UPER_LIMIT 0x80000000


class C_sensorData              // Class _ sensor Data 
{
    private: 
    PinName  ADC_pin;
    PinName  SDI_pin;
    PinName  SCK_pin;
    char     inst[18];          // Instruction/Data array
    uint16_t T1Trim;            // Unsigned int of 16 bits for temperature trim
    int16_t  T2Trim, T3Trim;    // Signed ints of 16 bits for temperature trim
    uint16_t P1Trim;            // Unsigned int of 16 bits for pressure trim
    int16_t  P2Trim, P3Trim, P4Trim, P5Trim, P6Trim, P7Trim, P8Trim, P9Trim; /* 
    Signed ints of 16 bits for temperature trim */
    int32_t  tempT, tempA, tempB;// Temporary working variables
    uint32_t tempP;              // Temporary working variables
    
    public:
    C_sensorData();
    TDS_sensorData read();
};

#endif