#ifndef __main__ //Inclusion safeguards
#define __main__

/* Libraries */
#include "mbed.h"
#include <iostream>
#include <string>
#include "ELEC351_LIBRARY.hpp"  // Including necessary Custom Library files 
#include "TextLCD.h"            /* Needed since my LCD driver has bug. for more 
details please see note in "ELEC351_LIBRARY.hpp"                              */
#include "SDBlockDevice.h"
#include "FATFileSystem.h"
#include "EthernetInterface.h"
#include "TCPServer.h"
#include "TCPSocket.h"


/* Defines */
#define DEF_SAMP_RATE 15        // Default sampling rate = 15sec
#define GET_SAMPLE  0x01        // Signal to thread to start sampling
#define DISP_SAMPLE 0x02        // Signal to thread to diplay sample
#define HTML_SAMPLE 0x04        // Signal to thread to update webpage
#define SD_SAMPLE   0x08        // Signal to thread to write tot sd card  

#define IP        "10.0.0.10"
#define NETMASK   "255.0.0.0"
#define GATEWAY   "10.0.0.1"


/* HTML */
#define HTTP_STATUS_LINE "HTTP/1.0 200 OK"
#define HTTP_HEADER_FIELDS "Content-Type: text/html; charset=utf-8"
#define HTTP_HEADER ""                                          \
"<html>" "\r\n"                                                 \
"  <body style=\"display:flex;text-align:center\">" "\r\n"      \
"    <div style=\"margin:auto\">" "\r\n"

#define HTTP_FOOTER ""                                          \
"    </div>" "\r\n"                                             \
"  </body>" "\r\n"                                              \
"</html>"

#define HTTP_RESPONSE HTTP_STATUS_LINE "\r\n"   \
                      HTTP_HEADER_FIELDS "\r\n" \
                      "\r\n"                    \
                      HTTP_MESSAGE_BODY "\r\n"


/* Function prototypes */
void samplingISR();
void samplingFunction();
void changeSamplingT(float interval);

#endif