#ifndef __recordsMaster__ //Inclusion safeguards
#define __recordsMaster__
#include "dateAndTime.hpp"
#include "samplingMaster.hpp"


typedef struct __attribute__ ((packed)) { // Store one after another

    TDS_DT          record_DT;   // Type Def Struct _ Date Time
    TDS_sensorData  record_Data; // Type Def Struct _ sensor Data

} TDS_record;                    // Type Def Struct _ record


class circularBuffer             // Class _ circular Buffer
{

private:
    TDS_record record[120]; /* Array of 120 TDS_records. Please note
    that this is not an instance variable and it does not need to be static
    since it is in the scope of the circularBuffer class which will not be
    deleted once called, otherwise where will you store your data. */
    TDS_record blankRecord;      // Blank record
    int bufferLoopBack;          // End of buffer (if END=1-START => Overrite next)
    Mutex recordLock;            /* Mutex when working with a data record. This 
    mutex is used for writing to ensure that the whole record is written before 
    it can be modified or read. Similarly, the mutex is used when reading to 
    ensure that the data read belongs to the same record and not to a new record
    that could have been written in the meantime. One such example that is 
    safeguarded against is the user reading a record when the sampling interupt 
    occurs. This would result in Date and Time belonging to one record but the 
    sensor data to another.
    Mitigation against deadlocks is handled by the nature of the scheduler since
    all producer threads push the data to be written to the stack so it is
    buffered if the mutex is locked. Even in the case of the Highst priority
    producer thread the data is buffered and the thread will be blocked until
    another mutex operation (reading or deleting record) is complete. Then the
    highest priority thread will write the buffered data.                     */
    
public:
    circularBuffer();       // Initilise buffer
    int write(TDS_record);  // Write single record to buffer
    int read(int);          // Read single record from buffer
    int del(int);           // Delete single record from buffer
    int readAll();          // Read all records from buffer
    int delAll();           // Delete all records from buffer
    int recNum();           // Returns last record number
    ~circularBuffer();      // Warn if buffer destroyed
};

#endif