#include "mbed.h"
#include "BufferedSerial.h"
#include "rplidar.h"

Serial pc(SERIAL_TX, SERIAL_RX, 1000000);
RPLidar lidar;
BufferedSerial se_lidar(PA_9, PA_10);
PwmOut rplidar_motor(A3);



int main()
{

    pc.baud(1000000);//115200);
    pc.printf("main\n");
    wait(1);

    rplidar_motor.period(0.001f);
    lidar.begin(se_lidar);
    lidar.setAngle(0,360);

    
    pc.printf("Program started.\n");
    
    
    lidar.startThreadScan();
    

    while(1) {
        struct RPLidarMeasurement data;
        // poll for measurements. Returns -1 if no new measurements are available. returns 0 if found one.
        if(lidar.pollSensorData(&data) == 0)
        {
            //if(data.angle < 5.0 && data.angle > -5.0)
            pc.printf("%f\t%f\t%d\t%c\n", data.distance, data.angle, data.quality, data.startBit);
        }
       //wait(0.02); 
    }
}
