#include "mbed.h"
#include "LSM303DLHC.h"

#define Rad2Dree       57.295779513082320876798154814105f

DigitalOut led1(LED1);

int main()
{
    Serial sp(USBTX, USBRX);
    sp.baud(115200);
    sp.printf("Accelerometer example\r\n");

    LSM303DLHC lsm303(p30, p7);
    lsm303.init();
    
    int accelReading[3];

    while(1)
    {
        led1 = 1;
        lsm303.readAcc(accelReading);
        
        sp.printf("Accelerometer read x = %d, y = %d, z = %d\r", accelReading[0], accelReading[1], accelReading[2]);
        
        wait(0.5);
        led1 = 0;
        wait(0.5);
    }
}

