#include "mbed.h"
#include "SDFileSystem.h"
#include "GPSGms6.h"
#include "FileManager.h"


// Connections to SD card holder on K64F (SPI interface)
SDFileSystem sd(PA_7, PA_6, PA_5, PA_0, DEVICE_NAME); // MOSI, MISO, SCK, CS
Serial serial(USBTX, USBRX);  // for PC debug
GPSGms6 gps;
Timeout t1;
DigitalOut myled(LED1);

float gps_interval = 3;


void t1out(void)
{
    myled = !myled;
    printf("\r\nGps header = %s", gps.latestGPRMC().header);
    printf("\r\nGps status = %s", gps.latestGPRMC().status);
    printf("\r\nGps time = %s", gps.latestGPRMC().time);
    printf("\r\nGps date = %s", gps.latestGPRMC().date);
    printf("\r\nGps lat = %s", gps.latestGPRMC().latitude);
    printf("\r\nGps long = %s", gps.latestGPRMC().longitude);
    printf("\r\nGps indicator = %s", gps.latestGPRMC().indicator);

    time_t seconds = time(NULL);
    logGPSData( (long) seconds,gps.latestGPRMC().date, gps.latestGPRMC().time);
    serial.printf("\r\n#### Restart Timer #####");
    
    tm t = gps.UTCTime();
    printf("\r\n UTC Time is %d/%d/%d %d:%d", t.tm_mday , t.tm_mon , t.tm_year , t.tm_hour, t.tm_min);
    
   
    printf("\r\nTime as a basic string = %s", ctime(&seconds));
    struct tm * ptm;
    
    time ( &seconds );
    
    ptm = localtime ( &seconds );
    printf ("\r\nCurrent time around the World:");
    printf ("\r\nPhoenix, AZ (U.S.) :  %2d:%02d\n %d-%d-%d", (ptm->tm_hour)%24, ptm->tm_min, t.tm_mday , t.tm_mon , t.tm_year);
    t1.attach(&t1out,gps_interval);
}

int main()
{
    serial.baud(9600);  // full-speed!
    serial.printf("\r\n#### SD Card Initialization #####");
    wait(1);

    ////////////////////// read Setup File  //////////////////////////
    readSetupFile();
    gps_interval = (float)GPSInterval()/1000;

    Variable_Data_TypeDef * var_list = readVarFile();
    logSystemData(gps_interval);

    unsigned int amount = getAmountVarList();
    for (int i = 0; i < amount ; i++) {
        serial.printf("\r\n var name = %s ",var_list[i].varName);
        serial.printf("\r\n first addr name = %s ",var_list[i].varAddress);
    }

    delete_file("/sd/2009-09-28.rtl.csv");
    ///////////////////////////////////////////////////
    serial.printf("\r\n####  End of SD Card Initialization #####");
    gps.start_GPS();
    t1.attach(&t1out,gps_interval);
    set_time(1460279787);  // Set RTC time to Sun, 10 Apr 2016 09:16:27 GMT
    
    
    while(1){
        
        wait(5);
        time_t seconds = time(NULL);
        seconds = time(NULL);
        float varList[] =  { 1.0,2.2,3.1};
        logRMSData(seconds,varList, 3);
          
    }
}


