//BluetoothBee.cpp

#include"BluetoothBee.h"
#include "mbed.h"

#define WAIT_TIME  2                        // wait time; you may need to increase this number for higher reliability (but slower) 

BluetoothBee::BluetoothBee(PinName tx, PinName rx) :Serial(tx,rx) {}

void BluetoothBee::setup() {
    baud(115200);                            // the Bluetooth Bee defaults to 38400 baud, 8N1 (8 data bits, no parity, 1 stop bit)
                                            // mbed defaults to 9600 8N1; thus, change baud rate to 38400
    printf("\r\n+STWMOD=0\r\n");            // set as slave mode
    wait(WAIT_TIME);
    printf("\r\n+STNA=Microbots\r\n");   // set device name as "BluetoothBee"
    wait(WAIT_TIME);
    printf("\r\n+STOAUT=1\r\n");            // allow devices to connect to module
    wait(WAIT_TIME);
    printf("\r\n+INQ=1\r\n");               // start broadcasting (make device visible)
    wait(WAIT_TIME);
}
