#include "mbed.h"
#include "tsi_sensor.h"
#include "MMA8451Q.h"

#define desactivado    1
#define activado       2

#define prendido       3
#define apagado        4

#define arroba         5
#define orden          6
#define parent         7

#if defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
#define ELEC0 9
#define ELEC1 10
#elif defined (TARGET_KL05Z)
#define ELEC0 9
#define ELEC1 8
#else
#error TARGET NOT DEFINED
#endif

#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
PinName const SDA = PTE25;
PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
PinName const SDA = PTB4;
PinName const SCL = PTB3;
#elif defined (TARGET_K20D50M)
PinName const SDA = PTB1;
PinName const SCL = PTB0;
#else
#error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)

Ticker delay;
Serial pc(USBTX, USBRX);//Definimos que el puerto serie se llama pc

void puls_h();
void me_gen();
void tiempo_leds();
void lee_recepcion();

TSIAnalogSlider tsi(ELEC0, ELEC1, 40);

MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);

DigitalIn EN_DIG(PTB2,PullUp);
AnalogIn EN_ANA(PTB3);

DigitalOut led(LED_GREEN);

char  c='\0';//Variable donde se guarda lo leido
//bit usado como flag para procesar datos
bool newdata = false;   //Se pone en true cuando hay nuevos datos

unsigned char puls=0,act=0,tp=0,ta=0,flag_camb_est=1;
unsigned char respuesta[6];

//Callback cuando se detecta una entrada
void onCharReceived()
{
    //Copiamos lo leido en c
    c = pc.getc();
    newdata = true;
}

int main(void)
{
    pc.attach(&onCharReceived);//Ejecutar onCharReceived por cada entrada por puerto
    delay.attach(tiempo_leds,0.01);
    led=1;
    pc.printf("MMA8451 ID: %d\n", acc.getWhoAmI());
    while (true) {
        puls_h();
        me_gen();
        lee_recepcion();
    }
}


void lee_recepcion()
{
    static int caso=arroba;
    float x, y, z;
    float voltaje=0;
    int voltaje_dec=0,voltaje_uni=0;
    int digital=0;
    int coord_uni=0,coord_dec=0;
    int primer_dig=0,segundo_dig=0;

    if(newdata && act==0) {
        newdata = false;
        c = '\0';//borra caracter
    }

    if(newdata && act==1) {
        newdata = false;
        switch(caso) {
            case arroba:
                if(c=='@') {
                    caso=orden;
                    respuesta[0]=c;
                }
                c = '\0';//Hacemos NULL c para que no vuelva a ejecutar
                break;
            case orden:
                if(c=='1' || c=='2' || c=='3' || c=='4' || c=='5') {
                    caso=parent;
                    switch(c) {
                        case '1'://ejex acelerometro
                            x = abs(acc.getAccX());
                            coord_dec = (int(x*10)) / 10;
                            coord_uni = (int(x*10)) % 10;
                            respuesta[1]=c;
                            respuesta[2]=coord_dec + 0x30;
                            respuesta[3]=coord_uni + 0x30;
                            break;
                        case '2'://ejey acel.
                            y = abs(acc.getAccY());
                            coord_dec = (int(y*10)) / 10;
                            coord_uni = (int(y*10)) % 10;
                            respuesta[1]=c;
                            respuesta[2]=coord_dec + 0x30;
                            respuesta[3]=coord_uni + 0x30;
                            break;
                        case '3'://ejez acel.
                            z = abs(acc.getAccZ());
                            coord_dec = (int(z*10)) / 10;
                            coord_uni = (int(z*10)) % 10;
                            respuesta[1]=c;
                            respuesta[2]=coord_dec + 0x30;
                            respuesta[3]=coord_uni + 0x30;
                            break;
                        case '4'://entrada analogica
                            voltaje = EN_ANA;
                            voltaje = voltaje * 3.3;
                            voltaje_dec = (int(voltaje*10)) / 10;
                            voltaje_uni = (int(voltaje*10)) % 10;
                            respuesta[1]=c;
                            respuesta[2]= voltaje_dec + 0x30;
                            respuesta[3]= voltaje_uni + 0x30;
                            break;

                        case '5'://entrada digital
                            digital = EN_DIG;
                            primer_dig = (digital*10) / 10;// La entrada digital va a valer 10 cuando sea 1 y 00 cuando sea 0
                            segundo_dig = (digital*10) % 10;
                            respuesta[1]=c;
                            respuesta[2]= primer_dig + 0x30;
                            respuesta[3]= segundo_dig + 0x30;
                            break;
                        default:
                            break;
                    }
                } else caso=arroba;
                c = '\0';
                break;
            case parent:
                if(c==')') {
                    respuesta[4]=(respuesta[0]^respuesta[1]^respuesta[2]^respuesta[3]);
                    respuesta[5]= 41;
                    caso=arroba;
                    pc.printf("\n\r");
                    for(int i=0; i<=5; i++) {
                        if(i!=4)pc.printf("%c",respuesta[i]);
                        if(i==4)pc.printf("%x",respuesta[i]);
                    }
                    pc.printf("\n\r");
                } else caso=arroba;
                c = '\0';
                break;

            default:
                caso=arroba;
                c = '\0';
                break;
        }
    }
}
void me_gen()
{
    static int caso=desactivado;

    switch(caso) {
        case desactivado:
            tp=25;
            ta=25;
            act=0;
            if(puls==1 && flag_camb_est==1) {
                flag_camb_est=0;
                caso=activado;
            }
            break;

        case activado:
            tp=20;
            ta=150;
            act=1;
            if(puls==1 && flag_camb_est==1) {
                flag_camb_est=0;
                caso=desactivado;
            }
            break;

        default:
            break;
    }
}

void tiempo_leds()
{
    static int tiempo=0,caso=prendido;
    switch(caso) {
        case prendido:
            if(tiempo<tp) {
                tiempo++;
                led=0;
            }
            if(tiempo>=tp) {
                tiempo=0;
                caso=apagado;
            }
            break;

        case apagado:
            if(tiempo<ta) {
                tiempo++;
                led=1;
            }
            if(tiempo>=ta) {
                tiempo=0;
                caso=prendido;
            }
            break;

        default:
            break;
    }
}

void puls_h()
{
    if(puls==1 && tsi.readPercentage() == 0) {
        flag_camb_est=1;
        puls=0;
    }
    if(puls==0 && tsi.readPercentage() != 0) puls=1;
}