#ifndef TUIASI_PIXYLINKI2C_H
#define TUIASI_PIXYLINKI2C_H

#include "I2C.h"
#include "PixyLink.h"

class PixyLinkI2C : public PixyLink, private I2C
{
public:
    PixyLinkI2C(PinName sda, PinName scl) :
        PixyLink(PIXY_DEFAULT_ADDR), I2C(sda, scl) {
    };

    virtual uint16_t getWord() {
        uint8_t data[2] = {0, 0};
        I2C::read((int)m_addr, (char *)data, 2);
        return ((uint16_t)data[1] << 8) | data[0];
    };

    virtual uint8_t getByte() {
        uint8_t data = 0;
        I2C::read((int)m_addr, (char*)&data, 1);
        return data;
    };

    virtual int8_t send(uint8_t *data, uint8_t len) {
        return I2C::write((int)m_addr, (char*)data, len);
    };


private:
    static const uint8_t PIXY_DEFAULT_ADDR = 0x54;
};

#endif //TUIASI_PIXYLINKI2C_H