#include "mbed.h"
#include "GPS.h"
#include "SDFileSystem.h"

Serial pc(USBTX,USBRX, 9600);
GPS my_gps(PA_9, PA_10);//Arduino pins D1, D0
DigitalOut myled(LED1);

Serial sim800(PA_2,PA_3, 9600);//Arduino pins A7, A2
SDFileSystem sd(SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS, "sd");//Arduino pins D11, D12, D13, D10
//                PB_5      PB_4     PB_3    PA_11

char* wapi_key = "4PI3GKVCH4OW96LX";

void init_sim(){
    sim800.printf("AT+CPIN?\r\n");
    wait(0.2);
    sim800.printf("AT+CGATT?\r\n");          //To check the GPRS is attached or not.
    wait(0.2);
    sim800.printf("AT+CIPSHUT\r\n");         //To reset the IP session if any.
    wait(0.2);
    sim800.printf("AT+SAPBR=3,1,\"CONTYPE\",\"GPRS\"\r\n");     //To Set the connection type to GPRS.
    wait(0.2);
    sim800.printf("AT+SAPBR=3,1,\"APN\",\"3IoT.com\"\r\n");
    wait(0.2);
    sim800.printf("AT+SAPBR=1,1\r\n");       //To Enable the GPRS.
    wait(0.2);
    sim800.printf("AT+SAPBR=2,1\r\n");       //To get the IP address.
    wait(0.2);
}

int new_file(char* adr_file)//fonction to write on new file
{
    FILE *fp = fopen(adr_file, "w");
    if(fp == NULL) {
        pc.printf("Unable to write the file\r\n");
        return -1;
    } else {
        fprintf(fp, "----New File----\r\n");
        fclose(fp);
        pc.printf("File successfully written!\r\n");
        return 0; //success
    }
}

int read_file(char* adr_file)//fct to read a file
{
    char c;
    FILE *file;
    pc.printf("\r\nRead: %s\r\n", adr_file);
    file = fopen(adr_file, "r");
    if (file) {
        while (!feof(file)) {
            c = getc(file);
            pc.putc(c);
        }
        fclose(file);
        return 0; //success
    }
    return -1;
}

int add_data(char* adr_flie, char* msg)//fct to update a file
{
    FILE *fp = fopen(adr_flie, "a");
    if(fp == NULL) {
        pc.printf("Unable to update the file\r\n");
        return 0; //success
    } else {
        fprintf(fp, msg);
        fclose(fp);
        pc.printf("File successfully update/written!\r\n");
        return -1;
    }
}

void send_ts(char* url_para)//Get url using sim800
{
    sim800.printf("AT+HTTPINIT\r\n");   //enable the HTTP mode.
    wait(0.2);
    sim800.printf("AT+HTTPPARA=\"CID\",1\r\n");  //To sets up HTTP parameters for the HTTP call.
    wait(0.2);
    sim800.printf(url_para);                 //Set URL
    wait(0.2);
    sim800.printf("AT+HTTPACTION=0\r\n");    //Start the HTTP GET session, by giving this command.
    wait(1);
    sim800.printf("AT+HTTPREAD\r\n");        //read the received data.
    wait(1);
    sim800.printf("AT+HTTPTERM\r\n");     //disable HTTP mode
    wait(0.2);
}

char msg_gps[300];
char url_sim[300];

int main() {
    pc.printf("\r\n*******TEST Send GPS Data*******\r\n");

    sim800.printf("ATZ\r\n");//reset SIM800H conf
    wait(1);
    //init sim conf & create new file
    init_sim();
    new_file("/sd/coordinate.txt");//create new "empty" juste wrote "New file"
    read_file("/sd/coordinate.txt");
    
    while(1) {

        if(my_gps.sample() == 1) {
            myled=1;
            
            //put data in string to send
            sprintf(url_sim,"AT+HTTPPARA=\"URL\",\"api.thingspeak.com/update?api_key=%s&field1=%f&field2=%f&field3=%f\"\r\n", wapi_key, my_gps.latitude, my_gps.longitude, my_gps.utc);
            sprintf(msg_gps,"GPS Coordinate: Latitude: %0.4f, Longitude: %f0.4, UTC: %f0.4\r\n", my_gps.latitude, my_gps.longitude, my_gps.utc);
            
            //send data to ThingSpeak channel & SD card
            send_ts(url_sim);
            add_data("/sd/coordinate.txt",msg_gps);
            
            //print data on terminal
            pc.printf("latitude: %0.2f, longitude: %0.2f, utc: %f\r\n", my_gps.latitude, my_gps.longitude, my_gps.utc);
            pc.printf("Msg: %s\r\n", my_gps.msg);
            
            myled=0;
            wait(60);//wait 60 sec for the test
        }
    }
}