#ifndef _MENBEDSTRUCTURE_H_
#define _MENBEDSTRUCTURE_H_

#include "mbed.h"

struct menuParam;
struct menuItem;
struct menu;

typedef struct menuParam menuParam_t;
typedef struct menuItem menuItem_t;
typedef struct menu menu_t;

struct menuParam{
    // Pointer to a function returning a float containing the current value of
    // the parameter.
    float (*initValFcn)(void);
    // Pointer to a function taking a float that is called when the parameter
    // value is modified.
    void (*finalValFcn)(float);
    // Copy of the initial value;
    float initVal;
    // Temporary copy of the parameter used to the hold the modified value
    // before it is committed.
    float tempVal;
    // Boolean indicating whether the finalValFcn should be called each time
    // the user makes a change to the variable or whether it should only be
    // called once the user confirms the change.
    bool liveUpdate;
    // Minimum allowable value.
    float min;
    // Maximum allowable value.
    float max;
    // Amount by which to increment/decrement the parameter with each presses of
    // the up/down button.
    float inc;
};

struct menuItem{
    // Pointer to function that will be called when menu item selected.  This
    // may be a null pointer if no function should be called.
    void (*selFcn)();
    // New menu to display when item selected.  This can be set to null if a
    // new menu item should not be called when the menu item is selected.
    menu_t *childMenu;
    // If true, childMenuIsAncestor indicates that the child menu's parent menu
    // should be set to null.  This will prevent the user from moving to the
    // from the child menu back to the current menu.  This is useful when the
    // menu item is something like "Goto root menu".   Once the user is in the
    // root menu, we don't want the user to press and hold the select key or
    // press the cancel key in order to return to the current menu.
    bool childMenuIsAncestor;
    // Pointer a structure which itself points to a float that will be displayed
    // in place of the %f in the text of the menu item.  If the param struct
    // has an inc memeber that is non-zero, the parameter can be modified by the
    // user.  In particular, when the user selects this menu item, the parameter
    // is highlighted and the user can then use the up and down buttons to
    // modify its value.
    menuParam_t *param;
    // Array of char pointers to the strings that will be catenated to form
    // the text of the menu item.  To insert either a menu parameter or state
    // variable into the menu item text, make one of the strings a printf-style
    // conversion specifier for a float.  (Note: only floats are allowed,
    // integer are not.)  The last string must be an empty string ("") to
    // indicate it is the last string in the array.  If the empty string is
    // omitted, unpredictable behavior will result.
    char *text[];
};


#endif /* _MENBEDSTRUCTURE_H_ */
