#ifndef _MENBEDNAVIGATOR_H_
#define _MENBEDNAVIGATOR_H_

#include "menbedButtonEvent.h"
#include "menbedStructure.h"
#include "menbedDisplayer.h"
#include "menbedMenu.h"

class MenbedNavigator {
public:
    MenbedNavigator (MenbedMenu *rootMenu, MenbedDisplayer *displayer);
    void updateDisplay (void);
    void handleButtonEvent (MenbedButtonEvent buttonEvent);
protected:
    MenbedMenu *activeMenu;
    uint8_t numButtons;
    uint8_t numLines;
    uint8_t lineLength;
    MenbedDisplayer *displayer;
    
    int8_t selectedItemIndex;
    uint8_t topOfScreenItemIndex;
    bool paramEditMode;

    void selectItem (void);
    void gotoParent (void);
    void moveUp (void);
    void moveDown (void);
    void incParam (void);
    void decParam (void);
    void saveParam (void);
    void restoreParam (void);
    void printMenu (char *menuStr);
    void printItem (MenbedMenuItem *item, char *line, bool itemSel, bool paramSel);
    bool checkConvSpec (const char *s);
};

#endif /* _MENBEDNAVIGATOR_H_ */