#ifndef _MENBEDMENUITEM_H_
#define _MENBEDMENUITEM_H_

#include <vector>
#include "mbed.h"
#include "menbedMenu.h"
#include "menbedMenuParam.h"

class MenbedMenu;

class MenbedMenuItem {
public:
    // Pointer to function that will be called when menu item selected.  This
    // may be a null pointer if no function should be called.
    void (*selFcn)();
    // New menu to display when item selected.  This can be set to null if a
    // new menu item should not be called when the menu item is selected.
    MenbedMenu **childMenu;
    // If true, childMenuIsAncestor indicates that the child menu's parent menu
    // should be set to null.  This will prevent the user from moving to the
    // from the child menu back to the current menu.  This is useful when the
    // menu item is something like "Goto root menu".   Once the user is in the
    // root menu, we don't want the user to press and hold the select key or
    // press the cancel key in order to return to the current menu.
    bool childMenuIsAncestor;
    // Pointer a structure which itself points to a float that will be displayed
    // in place of the %f in the text of the menu item.  If the param struct
    // has an inc memeber that is non-zero, the parameter can be modified by the
    // user.  In particular, when the user selects this menu item, the parameter
    // is highlighted and the user can then use the up and down buttons to
    // modify its value.
    MenbedMenuParam *param;
    // Array of char pointers to the strings that will be catenated to form
    // the text of the menu item.  To insert either a menu parameter or state
    // variable into the menu item text, make one of the strings a printf-style
    // conversion specifier for a float.  (Note: only floats are allowed,
    // integer are not.)  The last string must be an empty string ("") to
    // indicate it is the last string in the array.  If the empty string is
    // omitted, unpredictable behavior will result.
    char *text;
    
    MenbedMenuItem (void (*selFcn)(), MenbedMenu **childMenu, 
        bool childMenuIsAncestor, MenbedMenuParam *param, 
        char *text);
};

#endif /* _MENBEDMENUITEM_H_ */