#include "mbed.h"
#include "F746_GUI.hpp"
#include "TS_DISCO_F746NG.h"
#include "LCD_DISCO_F746NG.h"

LCD_DISCO_F746NG lcd;
TS_DISCO_F746NG ts;

PwmOut pouce(A5);
PwmOut index(A4);
PwmOut majeur(A3);
PwmOut annulaire(A2);
PwmOut auriculaire(A0);
PwmOut poignet(D3);
float us;

int main() {
   
    SeekBar auriculairebar(30,40,150,0,180,90,SeekBar::Vertical,0xFFB0B0FF,30,5);
    SeekBar annulairebar(70,40,150,0,180,90,SeekBar::Vertical,0xFFB0B0FF,30,5);
    SeekBar majeurbar(110,40,150,0,180,90,SeekBar::Vertical,0xFFB0B0FF,30,5);
    SeekBar indexbar(150,40,150,0,180,90,SeekBar::Vertical,0xFFB0B0FF,30,5);
    SeekBar poucebar(190,40,150,0,180,90,SeekBar::Vertical,0xFFB0B0FF,30,5);
    SeekBar poignetbar(40,230,150,0,180,90,SeekBar::Holizontal,0xFFB0B0FF,30,5);
    Button reset(270,30,80,40,"Reset",Font16,LCD_COLOR_WHITE,LCD_COLOR_BLUE);
    Button poing(380,30,80,40,"Poing",Font16,LCD_COLOR_WHITE,LCD_COLOR_BLUE);
    Button doigt(270,100,80,40,"Cencurer",Font12,LCD_COLOR_WHITE,LCD_COLOR_BLUE);
    Button metal(380,100,80,40,"Metal",Font16,LCD_COLOR_WHITE,LCD_COLOR_BLUE);
    Button pointe(270,170,80,40,"Pointe",Font16,LCD_COLOR_WHITE,LCD_COLOR_BLUE);
    Button ok(380,170,80,40,"OK",Font16,LCD_COLOR_WHITE,LCD_COLOR_BLUE);
    
    pouce.pulsewidth_us(1500);
    index.pulsewidth_us(1500);
    majeur.pulsewidth_us(1500);
    annulaire.pulsewidth_us(1500);
    auriculaire.pulsewidth_us(1500);
    poignet.pulsewidth_us(1500);
    lcd.DrawVLine(250, 0, 300);
   
    
    wait(2);
    
         while(1){
            lcd.DisplayStringAt(5,5, (uint8_t *)"MODE LIBRE",LEFT_MODE);
            lcd.DisplayStringAt(5,5, (uint8_t *)"MODE PREPROGRAMMER",RIGHT_MODE);
             
         if (auriculairebar.Slide()) {
            //labelServo.Draw("%%%5.1f", auriculairebar .GetValue());
            us = auriculairebar.GetValue()*((1500/180)*2);
            auriculaire.pulsewidth_us(us);
            }
            
         if (annulairebar.Slide()) {
            us = annulairebar.GetValue()*((1500/180)*2);
            annulaire.pulsewidth_us(us);
            }   
            
        if (majeurbar.Slide()) {
            //labelServo.Draw("%%%5.1f", auriculairebar .GetValue());
            us = majeurbar.GetValue()*((1500/180)*2);
            majeur.pulsewidth_us(us);
            }
            
        if (indexbar.Slide()) {
            //labelServo.Draw("%%%5.1f", auriculairebar .GetValue());
            us = indexbar.GetValue()*((1500/180)*2);
            index.pulsewidth_us(us);
            }  
            
         if (poucebar.Slide()) {
            //labelServo.Draw("%%%5.1f", auriculairebar .GetValue());
            us = poucebar.GetValue()*((1500/180)*2);
            pouce.pulsewidth_us(us);
            }
            
        if (poignetbar.Slide()) {
            //labelServo.Draw("%%%5.1f", auriculairebar .GetValue());
            us = poignetbar.GetValue()*((1500/180)*2);
            poignet.pulsewidth_us(us);
            }
            
        if(reset.Touched())
        {
            pouce.pulsewidth_us(1500);
            index.pulsewidth_us(1500);
            majeur.pulsewidth_us(1500);
            annulaire.pulsewidth_us(1500);
            auriculaire.pulsewidth_us(1500);
            poignet.pulsewidth_us(1500);
        }
            
            if(poing.Touched())
        {
            pouce.pulsewidth_us(1900);
            index.pulsewidth_us(1900);
            majeur.pulsewidth_us(1900);
            annulaire.pulsewidth_us(1900);
            auriculaire.pulsewidth_us(1900);
            poignet.pulsewidth_us(1500);
            
        }
        
         if(doigt.Touched())
        {
            pouce.pulsewidth_us(1900);
            index.pulsewidth_us(1900);
            majeur.pulsewidth_us(450);
            annulaire.pulsewidth_us(1900);
            auriculaire.pulsewidth_us(1900);
            poignet.pulsewidth_us(1500);
            
        }
        
         if(metal.Touched())
        {
            pouce.pulsewidth_us(1900);
            index.pulsewidth_us(450);
            majeur.pulsewidth_us(1900);
            annulaire.pulsewidth_us(1900);
            auriculaire.pulsewidth_us(450);
            poignet.pulsewidth_us(1500);
            
        }
           if(pointe.Touched())
        {
            pouce.pulsewidth_us(1900);
            index.pulsewidth_us(450);
            majeur.pulsewidth_us(1900);
            annulaire.pulsewidth_us(1900);
            auriculaire.pulsewidth_us(1900);
            poignet.pulsewidth_us(450);
            
        }
        
        if(ok.Touched())
        {
            pouce.pulsewidth_us(1700);
            index.pulsewidth_us(1600);
            majeur.pulsewidth_us(450);
            annulaire.pulsewidth_us(450);
            auriculaire.pulsewidth_us(450);
            poignet.pulsewidth_us(1500);
            
        }
           
            
        }  
     }

    
 
 