#include "mbed.h"
#include <string.h>
#include <stdlib.h>

/* Commands:
    Dd      - Data out (2 bytes long)
    Cx      - CS line state (0/1)
    R      - Receive data
*/

DigitalOut myled(LED1); //blinks when talking (via TeraTerm) through SPI
SPI spi_device(p5, p6, p7); //p5=mosi, p6=miso, p7=sclock
DigitalOut spi_cs(p8); //Cs line, 0 = on, 1 = off
AnalogIn voltage(p20); //voltage being read

Serial tty_usb(USBTX, USBRX); //generates serial communication through USB
char tty_buffer[0x100]; //?

void receive_command() {//waits to receive commands
    uint8_t buffer_ptr = 0;
    char ch;

    tty_usb.putc('>');//puts > on input line
    while (1) {//waits for input

        if (tty_usb.readable()) {
            ch = tty_usb.getc();
            tty_usb.putc(ch);
            tty_buffer[buffer_ptr] = ch;
            buffer_ptr++;
            if ((ch == '\n') || (ch == '\r')) {
                tty_usb.putc('\n');
                tty_usb.putc('\r');
                break;
            }
            if (ch == 0x7f) {
                buffer_ptr -= 2;
                tty_usb.putc(0x8);
                tty_usb.putc(' ');
                tty_usb.putc(0x8);
            }
        }
    }
}
int main() {
    uint16_t arg_data, arg_data_in;
    float placeholder = voltage.read()*10/3;
    tty_usb.baud(9600);
    while(1) {        
        receive_command();
        switch (tty_buffer[0]) {
            case 'D':
            case 'd':
                arg_data = strtol(&tty_buffer[1], NULL, 16);
                arg_data_in = spi_device.write(arg_data);
                tty_usb.printf("#\tSingle data: OUT: $%04X -  IN: $%02X\n\r", arg_data, arg_data_in);
                break;
            case 'C':
            case 'c':
                spi_cs = (tty_buffer[1] == '0') ? 0 : 1;
                break;
            case 'R':
            case 'r':
                tty_usb.printf("The old voltage was: %.02f\r\nThe voltage being read in now is: %.02f\r\n",placeholder,voltage.read()*10/3);
                placeholder=voltage.read()*10/3;
                break;               
        }
    }
}
