#ifndef PARKING_THREAD_H
#define PARKING_THREAD_H

#include <mbed.h>
#include <I2C.h>
#include "rtos.h"
#include "Periphery/SupportSystem.h"

extern SupportSystem *supportSystem;
extern Queue<float, 2> quadrature_queue;
extern Queue<float, 2> machine_direction_queue;
extern float steering_angle_minnow_queue;
extern float velocity_minnow_queue;
extern uint8_t current_imaging_modus;
extern Queue<uint8_t, 2> serial_input_modus_queue;

/*
 * Necessary for strcut sizes
 */
#pragma pack (1)

class Parking{
public:
    static DigitalIn redlight;
    static uint64_t lightimpulseCounter;
    static int getDistance();
    static void parking_thread(void const *args);
    static void increaseLightimpulseCounter();
};

#endif