#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
// modif LR : config adresse IP
EthernetNetIf ethif( IpAddr(192,168,1,102), // IP
                     IpAddr(255,255,255,0), // Subnet mask
                     IpAddr(192,168,1,1),   // Gateway
                     IpAddr(192,168,1,1) ); // DNS
HTTPServer server;
LocalFileSystem local("local"); // Define local file mount point
DigitalOut led1(LED1);  // for alive check

int main(void)
{
    // EthernetNetIf setup
    if( ethif.setup() )
    {
        return 1;
    }

    // Mount local file path on web root path
    FSHandler::mount("/local", "/");
    // Set web root path handler
    server.addHandler<FSHandler>("/");
    
    // Set http port
    server.bind(80); // port 80 

    Timer tm;
    tm.start();
    while(1)
    {
        Net::poll();
        if( 1.0 < tm.read() )
        {
            led1 = !led1;   // high->low, low->high
            tm.start();
        }
    }
}