#include "mbed.h"
#include "GMMP.h"

byte serverIp[] = {61,250,21,211};
const int serverPort = 31002;
const char* serverDomain = "ThingPlug";
const char* serverId = "0002f7f00000";
byte serverMac[] = {0x00, 0x02, 0xF7, 0x00, 0x00};
const char* regId = "mbed";

const char* pszGWMFID = "mbed";
const char* pszDeviceMFID = "mbed";
char* deviceId[LEN_DEVICE_ID];


#define BUF_SIZE 10
Timer t;
GMMPHeader header;
void *pBody = NULL;
char sendBuf[BUF_SIZE];

int Recv(GMMPHeader* pstGMMPHeader, void* pBody) {
    U8 cMessageType = pstGMMPHeader->ucMessageType;
    INFO("MsgType: %d", cMessageType);
    
    return 0;
}

int setup(void) {
    t.start();
    INFO("Setup Start");
    
    mbed_mac_address((char*)serverMac);
    if (Initialize(serverIp, serverPort, serverDomain, serverId, serverMac)) {
        INFO("Initialize failed!");
        return 0;
    }
    
    SetCallFunction(Recv);
    
    int ret = GO_Reg(NULL, regId);
    
    if (ret != GMMP_SUCCESS) {
        ERR("Regist Fail [%d]", ret);
        INFO("Setup Fail. Please check your configuration");
        return 0;
    }
    INFO("Setup Success");
    return 1;
}
int count = 0;
void loop(void) {
    INFO("LOOP start");
    
    int ret = GetReadData(&header, &pBody);
    INFO("GetReadData [RET:%d][BODY:%s]", ret, pBody);
    
    sprintf(sendBuf, "%d", count++);
    
    ret = GO_Delivery(GetGWID(), NULL, DELIVERY_COLLECT_DATA, 0x01, sendBuf);
    INFO("Send Data [RET:%d][DATA:%s]", ret, sendBuf);
}

int main() {
    int setupStatus = 0;
    for(;setupStatus==0;) {
        setupStatus = setup();
    }
    while(1) {
        wait(1.0);
        loop();
    }
}
