/*
 * GMMP_Util.c
 *
 *  Created on: 2013. 11. 27.
 *      Author: root
 */

#include "GMMP_Util.h"

short ltobs(const short nShort)
{
	return _btols(nShort);
}

short btols(const short nShort)
{
	return _btols(nShort);
}

short _btols(const short nShort)
{
	short nValue = 0;

	nValue = (unsigned short)nShort >> 8;
	nValue |=(unsigned short) nShort << 8;

	return  nValue;
}

long ltobi(const long nInt)
{
	return _ltobi(nInt);
}

long btoli(const long nInt)
{
	return _ltobi(nInt);
}

long _ltobi(const long nInt)
{
	long nVal0, nVal1, nVal2, nVal3;

	nVal0 =  (unsigned long)nInt >> 24;
	nVal1 =  (unsigned long)(nInt & 0x00FF0000) >> 8;
	nVal2 =  (unsigned long)(nInt & 0x0000FF00) << 8;
	nVal3 =  (unsigned long)nInt << 24;

	return (nVal0 | nVal1 | nVal2 | nVal3);
}

int freeRam () {
  // __brkval is the address of the top of the heap
  // if memory has been allocated.
  // If __brkval is zero then it means malloc has not used any memory yet, so
  // we look at the address of __heap_start.
  
  return 0;
}
