/**
 ******************************************************************************
 * @file    main.cpp
 * @author  IPC Rennes
 * @version V1.0.0
 * @date    April 25th, 2016
 * @brief   mbed simple application for the STMicroelectronics X-NUCLEO-IHM12A1
 *          Motor Control Expansion Board: control of 2 Brush DC motors.
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2016 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
 */

/* Includes ------------------------------------------------------------------*/

/* mbed specific header files. */
#include "mbed.h"
#include "color.h"
#include "hcsr04.h"
#include "BDCMotor.h"

/* Component specific header files. */
#include "STSpin240_250.h"
HCSR04 sensor1(D10, D11);

ColorSensor color(D4, D5, D6, D7, D8);

/* Variables -----------------------------------------------------------------*/

/* Initialization parameters of the motor connected to the expansion board. */
 STSpin240_250_init_t init =
 {
  20000, /* Frequency of PWM of Input Bridge A in Hz up to 100000Hz             */
  20000, /* Frequency of PWM of Input Bridge B in Hz up to 100000Hz             */
  20000, /* Frequency of PWM used for Ref pin in Hz up to 100000Hz              */
  50,    /* Duty cycle of PWM used for Ref pin (from 0 to 100)                  */
  TRUE   /* Dual Bridge configuration  (FALSE for mono, TRUE for dual brush dc) */
 };

/* Motor Control Component. */
STSpin240_250 *motor;

/* Functions -----------------------------------------------------------------*/

/**
 * @brief  This is an example of error handler.
 * @param[in] error Number of the error
 * @retval None
 * @note   If needed, implement it, and then attach it:
 *           + motor->attach_error_handler(&my_error_handler);
 */
void my_error_handler(uint16_t error)
{
  /* Printing to the console. */
  printf("Error %d detected\r\n\n", error);
  
  /* Infinite loop */
  while (true) {
  }    
}

/**
 * @brief  This is an example of user handler for the flag interrupt.
 * @param  None
 * @retval None
 * @note   If needed, implement it, and then attach and enable it:
 *           + motor->attach_flag_irq(&my_flag_irq_handler);
 *           + motor->enable_flag_irq();
 *         To disable it:
 *           + motor->DisbleFlagIRQ();
 */
void my_flag_irq_handler(void)
{
   /* Code to be customised */
  /************************/

  printf("    WARNING: \"FLAG\" interrupt triggered.\r\n");

  /* Get the state of bridge A */
  uint16_t bridgeState  = motor->get_bridge_status(0);
  
  if (bridgeState == 0)  {
    if (motor->get_device_state(0) != INACTIVE) {
      /* Bridges were disabled due to overcurrent or over temperature */
      /* When  motor was running */
      my_error_handler(0XBAD0);
    }
  }
}

/* Main ----------------------------------------------------------------------*/

int main()
{
  
  /* Printing to the console. */
  printf("STARTING MAIN PROGRAM\r\n");
    
//----- Initialization 
  
  /* Initializing Motor Control Component. */
  #if (defined TARGET_NUCLEO_F030R8)||(defined TARGET_NUCLEO_F334R8)
  motor = new STSpin240_250(D2, D9, D6, D7, D5, D4, A2);
  #elif (defined TARGET_NUCLEO_L152RE)
  motor = new STSpin240_250(D2, D9, D6, D7, D5, D4, A3);
  #else
  motor = new STSpin240_250(D2, D9, D6, D7, D5, D4, A0);
  #endif
  if (motor->init(&init) != COMPONENT_OK) exit(EXIT_FAILURE);

  /* Set dual bridge enabled as two motors are used*/
  motor->set_dual_full_bridge_config(1);

  /* Attaching and enabling an interrupt handler. */
  motor->attach_flag_irq(&my_flag_irq_handler);
  motor->enable_flag_irq();
    
  /* Attaching an error handler */
  motor->attach_error_handler(&my_error_handler);

  /* Printing to the console. */
  printf("Motor Control Application Example for 2 brush DC motors\r\n");

  /* Set PWM Frequency of Ref to 15000 Hz */ 
  motor->set_ref_pwm_freq(0, 15000); 

  /* Set PWM duty cycle of Ref to 60% */ 
  motor->set_ref_pwm_dc(0, 60); 
  
  /* Set PWM Frequency of bridge A inputs to 10000 Hz */ 
  motor->set_bridge_input_pwm_freq(0,10000); 
  
  /* Set PWM Frequency of bridge B inputs to 10000 Hz */ 
  motor->set_bridge_input_pwm_freq(1,10000); 
  
  /* Infinite Loop. */
  printf("--> Infinite Loop...\r\n");
  bool fase = 1;
  while (true) {
    motor->run(0, BDCMotor::FWD);
    motor->run(1, BDCMotor::FWD);    
    motor->set_speed(1,49); 
    motor->set_speed(0,50);    
    sensor1.start();    
    if (sensor1.get_dist_cm() < 10){
        fase = !fase;
      if (fase == 0){              
        wait_ms(2500);        
          motor->set_speed(1,15); 
          motor->set_speed(0,50);         
        wait_ms(500);         
          motor->set_speed(1,49); 
          motor->set_speed(0,50); 
      }
      else
      {              
          wait_ms(2500);        
          motor->set_speed(1,50); 
          motor->set_speed(0,15);         
          wait_ms(500);         
          motor->set_speed(1,49); 
          motor->set_speed(0,50); 
      }
   }
   
   if(color.getRed()>100&&color.getGreen()>100)
   {
        //se vede il giallo allora fa questo
   }    
   if(color.getRed()>130&&color.getGreen()>130&&color.getBlue()>130){
       //se vede il bianco allora fa questo
       unsigned int motorino=
   }
   if(color.getRed()>110){
       //se vede il rosso
       motor->hard_stop(0);
       motor->hard_stop(1);
       wait(2);
   }
  }
}

/*********** (C) COPYRIGHT STMicroelectronics ********** END OF FILE **********/
