/* mbed TCG SPI TPM 2.0 TIS 1.3 driver,
 * Copyright (c) 2015, Microsoft Coprporation Inc.
 * by Stefan Thom (LordOfDorks) StefanTh@Microsoft.com, Stefan@ThomsR.Us
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * The TPM 2.0 architecture, commands and structures are defined in the set of 4 
 * Trusted Platform Module Library Specification, Family "2.0" specifications that
 * that can be found at
 * http://www.trustedcomputinggroup.org/resources/tpm_library_specification
 *
 */

#ifndef TPM_TIS_NO_COMMAND_FILTERING

#define PAD_LIST 0

const TPMA_CC s_ccAttr [] =
{
#if (PAD_LIST || CC_NV_UndefineSpaceSpecial)
    {0x011f, 0, 1, 0, 0, 2, 0, 0, 0},     // TPM_CC_NV_UndefineSpaceSpecial
#endif
#if (PAD_LIST || CC_EvictControl)
    {0x0120, 0, 1, 0, 0, 2, 0, 0, 0},     // TPM_CC_EvictControl
#endif
#if (PAD_LIST || CC_HierarchyControl)
    {0x0121, 0, 1, 1, 0, 1, 0, 0, 0},     // TPM_CC_HierarchyControl
#endif
#if (PAD_LIST || CC_NV_UndefineSpace)
    {0x0122, 0, 1, 0, 0, 2, 0, 0, 0},     // TPM_CC_NV_UndefineSpace
#endif
#if (PAD_LIST)
    {0x0123, 0, 0, 0, 0, 0, 0, 0, 0},     // No command
#endif
#if (PAD_LIST || CC_ChangeEPS)
    {0x0124, 0, 1, 1, 0, 1, 0, 0, 0},     // TPM_CC_ChangeEPS
#endif
#if (PAD_LIST || CC_ChangePPS)
    {0x0125, 0, 1, 1, 0, 1, 0, 0, 0},     // TPM_CC_ChangePPS
#endif
#if (PAD_LIST || CC_Clear)
    {0x0126, 0, 1, 1, 0, 1, 0, 0, 0},     // TPM_CC_Clear
#endif
#if (PAD_LIST || CC_ClearControl)
    {0x0127, 0, 1, 0, 0, 1, 0, 0, 0},     // TPM_CC_ClearControl
#endif
#if (PAD_LIST || CC_ClockSet)
    {0x0128, 0, 1, 0, 0, 1, 0, 0, 0},     // TPM_CC_ClockSet
#endif
#if (PAD_LIST || CC_HierarchyChangeAuth)
    {0x0129, 0, 1, 0, 0, 1, 0, 0, 0},     // TPM_CC_HierarchyChangeAuth
#endif
#if (PAD_LIST || CC_NV_DefineSpace)
    {0x012a, 0, 1, 0, 0, 1, 0, 0, 0},     // TPM_CC_NV_DefineSpace
#endif
#if (PAD_LIST || CC_PCR_Allocate)
    {0x012b, 0, 1, 0, 0, 1, 0, 0, 0},     // TPM_CC_PCR_Allocate
#endif
#if (PAD_LIST || CC_PCR_SetAuthPolicy)
    {0x012c, 0, 1, 0, 0, 1, 0, 0, 0},     // TPM_CC_PCR_SetAuthPolicy
#endif
#if (PAD_LIST || CC_PP_Commands)
    {0x012d, 0, 1, 0, 0, 1, 0, 0, 0},     // TPM_CC_PP_Commands
#endif
#if (PAD_LIST || CC_SetPrimaryPolicy)
    {0x012e, 0, 1, 0, 0, 1, 0, 0, 0},     // TPM_CC_SetPrimaryPolicy
#endif
#if (PAD_LIST || CC_FieldUpgradeStart)
    {0x012f, 0, 0, 0, 0, 2, 0, 0, 0},     // TPM_CC_FieldUpgradeStart
#endif
#if (PAD_LIST || CC_ClockRateAdjust)
    {0x0130, 0, 0, 0, 0, 1, 0, 0, 0},     // TPM_CC_ClockRateAdjust
#endif
#if (PAD_LIST || CC_CreatePrimary)
    {0x0131, 0, 0, 0, 0, 1, 1, 0, 0},     // TPM_CC_CreatePrimary
#endif
#if (PAD_LIST || CC_NV_GlobalWriteLock)
    {0x0132, 0, 0, 0, 0, 1, 0, 0, 0},     // TPM_CC_NV_GlobalWriteLock
#endif
#if (PAD_LIST || CC_GetCommandAuditDigest)
    {0x0133, 0, 1, 0, 0, 2, 0, 0, 0},     // TPM_CC_GetCommandAuditDigest
#endif
#if (PAD_LIST || CC_NV_Increment)
    {0x0134, 0, 1, 0, 0, 2, 0, 0, 0},     // TPM_CC_NV_Increment
#endif
#if (PAD_LIST || CC_NV_SetBits)
    {0x0135, 0, 1, 0, 0, 2, 0, 0, 0},     // TPM_CC_NV_SetBits
#endif
#if (PAD_LIST || CC_NV_Extend)
    {0x0136, 0, 1, 0, 0, 2, 0, 0, 0},     // TPM_CC_NV_Extend
#endif
#if (PAD_LIST || CC_NV_Write)
    {0x0137, 0, 1, 0, 0, 2, 0, 0, 0},     // TPM_CC_NV_Write
#endif
#if (PAD_LIST || CC_NV_WriteLock)
    {0x0138, 0, 1, 0, 0, 2, 0, 0, 0},     // TPM_CC_NV_WriteLock
#endif
#if (PAD_LIST || CC_DictionaryAttackLockReset)
    {0x0139, 0, 1, 0, 0, 1, 0, 0, 0},     // TPM_CC_DictionaryAttackLockReset
#endif
#if (PAD_LIST || CC_DictionaryAttackParameters)
    {0x013a, 0, 1, 0, 0, 1, 0, 0, 0},     // TPM_CC_DictionaryAttackParameters
#endif
#if (PAD_LIST || CC_NV_ChangeAuth)
    {0x013b, 0, 1, 0, 0, 1, 0, 0, 0},     // TPM_CC_NV_ChangeAuth
#endif
#if (PAD_LIST || CC_PCR_Event)
    {0x013c, 0, 1, 0, 0, 1, 0, 0, 0},     // TPM_CC_PCR_Event
#endif
#if (PAD_LIST || CC_PCR_Reset)
    {0x013d, 0, 1, 0, 0, 1, 0, 0, 0},     // TPM_CC_PCR_Reset
#endif
#if (PAD_LIST || CC_SequenceComplete)
    {0x013e, 0, 0, 0, 1, 1, 0, 0, 0},     // TPM_CC_SequenceComplete
#endif
#if (PAD_LIST || CC_SetAlgorithmSet)
    {0x013f, 0, 1, 0, 0, 1, 0, 0, 0},     // TPM_CC_SetAlgorithmSet
#endif
#if (PAD_LIST || CC_SetCommandCodeAuditStatus)
    {0x0140, 0, 1, 0, 0, 1, 0, 0, 0},     // TPM_CC_SetCommandCodeAuditStatus
#endif
#if (PAD_LIST || CC_FieldUpgradeData)
    {0x0141, 0, 1, 0, 0, 0, 0, 0, 0},     // TPM_CC_FieldUpgradeData
#endif
#if (PAD_LIST || CC_IncrementalSelfTest)
    {0x0142, 0, 1, 0, 0, 0, 0, 0, 0},     // TPM_CC_IncrementalSelfTest
#endif
#if (PAD_LIST || CC_SelfTest)
    {0x0143, 0, 1, 0, 0, 0, 0, 0, 0},     // TPM_CC_SelfTest
#endif
#if (PAD_LIST || CC_Startup)
    {0x0144, 0, 1, 0, 0, 0, 0, 0, 0},     // TPM_CC_Startup
#endif
#if (PAD_LIST || CC_Shutdown)
    {0x0145, 0, 1, 0, 0, 0, 0, 0, 0},     // TPM_CC_Shutdown
#endif
#if (PAD_LIST || CC_StirRandom)
    {0x0146, 0, 1, 0, 0, 0, 0, 0, 0},     // TPM_CC_StirRandom
#endif
#if (PAD_LIST || CC_ActivateCredential)
    {0x0147, 0, 0, 0, 0, 2, 0, 0, 0},     // TPM_CC_ActivateCredential
#endif
#if (PAD_LIST || CC_Certify)
    {0x0148, 0, 0, 0, 0, 2, 0, 0, 0},     // TPM_CC_Certify
#endif
#if (PAD_LIST || CC_PolicyNV)
    {0x0149, 0, 0, 0, 0, 3, 0, 0, 0},     // TPM_CC_PolicyNV
#endif
#if (PAD_LIST || CC_CertifyCreation)
    {0x014a, 0, 0, 0, 0, 2, 0, 0, 0},     // TPM_CC_CertifyCreation
#endif
#if (PAD_LIST || CC_Duplicate)
    {0x014b, 0, 0, 0, 0, 2, 0, 0, 0},     // TPM_CC_Duplicate
#endif
#if (PAD_LIST || CC_GetTime)
    {0x014c, 0, 0, 0, 0, 2, 0, 0, 0},     // TPM_CC_GetTime
#endif
#if (PAD_LIST || CC_GetSessionAuditDigest)
    {0x014d, 0, 0, 0, 0, 3, 0, 0, 0},     // TPM_CC_GetSessionAuditDigest
#endif
#if (PAD_LIST || CC_NV_Read)
    {0x014e, 0, 0, 0, 0, 2, 0, 0, 0},     // TPM_CC_NV_Read
#endif
#if (PAD_LIST || CC_NV_ReadLock)
    {0x014f, 0, 0, 0, 0, 2, 0, 0, 0},     // TPM_CC_NV_ReadLock
#endif
#if (PAD_LIST || CC_ObjectChangeAuth)
    {0x0150, 0, 0, 0, 0, 2, 0, 0, 0},     // TPM_CC_ObjectChangeAuth
#endif
#if (PAD_LIST || CC_PolicySecret)
    {0x0151, 0, 0, 0, 0, 2, 0, 0, 0},     // TPM_CC_PolicySecret
#endif
#if (PAD_LIST || CC_Rewrap)
    {0x0152, 0, 0, 0, 0, 2, 0, 0, 0},     // TPM_CC_Rewrap
#endif
#if (PAD_LIST || CC_Create)
    {0x0153, 0, 0, 0, 0, 1, 0, 0, 0},     // TPM_CC_Create
#endif
#if (PAD_LIST || CC_ECDH_ZGen)
    {0x0154, 0, 0, 0, 0, 1, 0, 0, 0},     // TPM_CC_ECDH_ZGen
#endif
#if (PAD_LIST || CC_HMAC)
    {0x0155, 0, 0, 0, 0, 1, 0, 0, 0},     // TPM_CC_HMAC
#endif
#if (PAD_LIST || CC_Import)
    {0x0156, 0, 0, 0, 0, 1, 0, 0, 0},     // TPM_CC_Import
#endif
#if (PAD_LIST || CC_Load)
    {0x0157, 0, 0, 0, 0, 1, 1, 0, 0},     // TPM_CC_Load
#endif
#if (PAD_LIST || CC_Quote)
    {0x0158, 0, 0, 0, 0, 1, 0, 0, 0},     // TPM_CC_Quote
#endif
#if (PAD_LIST || CC_RSA_Decrypt)
    {0x0159, 0, 0, 0, 0, 1, 0, 0, 0},     // TPM_CC_RSA_Decrypt
#endif
#if (PAD_LIST)
    {0x015a, 0, 0, 0, 0, 0, 0, 0, 0},     // No command
#endif
#if (PAD_LIST || CC_HMAC_Start)
    {0x015b, 0, 0, 0, 0, 1, 1, 0, 0},     // TPM_CC_HMAC_Start
#endif
#if (PAD_LIST || CC_SequenceUpdate)
    {0x015c, 0, 0, 0, 0, 1, 0, 0, 0},     // TPM_CC_SequenceUpdate
#endif
#if (PAD_LIST || CC_Sign)
    {0x015d, 0, 0, 0, 0, 1, 0, 0, 0},     // TPM_CC_Sign
#endif
#if (PAD_LIST || CC_Unseal)
    {0x015e, 0, 0, 0, 0, 1, 0, 0, 0},     // TPM_CC_Unseal
#endif
#if (PAD_LIST)
    {0x015f, 0, 0, 0, 0, 0, 0, 0, 0},     // No command
#endif
#if (PAD_LIST || CC_PolicySigned)
    {0x0160, 0, 0, 0, 0, 2, 0, 0, 0},     // TPM_CC_PolicySigned
#endif
#if (PAD_LIST || CC_ContextLoad)
    {0x0161, 0, 0, 0, 0, 0, 1, 0, 0},     // TPM_CC_ContextLoad
#endif
#if (PAD_LIST || CC_ContextSave)
    {0x0162, 0, 0, 0, 0, 1, 0, 0, 0},     // TPM_CC_ContextSave
#endif
#if (PAD_LIST || CC_ECDH_KeyGen)
    {0x0163, 0, 0, 0, 0, 1, 0, 0, 0},     // TPM_CC_ECDH_KeyGen
#endif
#if (PAD_LIST || CC_EncryptDecrypt)
    {0x0164, 0, 0, 0, 0, 1, 0, 0, 0},     // TPM_CC_EncryptDecrypt
#endif
#if (PAD_LIST || CC_FlushContext)
    {0x0165, 0, 0, 0, 0, 0, 0, 0, 0},     // TPM_CC_FlushContext
#endif
#if (PAD_LIST)
    {0x0166, 0, 0, 0, 0, 0, 0, 0, 0},     // No command
#endif
#if (PAD_LIST || CC_LoadExternal)
    {0x0167, 0, 0, 0, 0, 0, 1, 0, 0},     // TPM_CC_LoadExternal
#endif
#if (PAD_LIST || CC_MakeCredential)
    {0x0168, 0, 0, 0, 0, 1, 0, 0, 0},     // TPM_CC_MakeCredential
#endif
#if (PAD_LIST || CC_NV_ReadPublic)
    {0x0169, 0, 0, 0, 0, 1, 0, 0, 0},     // TPM_CC_NV_ReadPublic
#endif
#if (PAD_LIST || CC_PolicyAuthorize)
    {0x016a, 0, 0, 0, 0, 1, 0, 0, 0},     // TPM_CC_PolicyAuthorize
#endif
#if (PAD_LIST || CC_PolicyAuthValue)
    {0x016b, 0, 0, 0, 0, 1, 0, 0, 0},     // TPM_CC_PolicyAuthValue
#endif
#if (PAD_LIST || CC_PolicyCommandCode)
    {0x016c, 0, 0, 0, 0, 1, 0, 0, 0},     // TPM_CC_PolicyCommandCode
#endif
#if (PAD_LIST || CC_PolicyCounterTimer)
    {0x016d, 0, 0, 0, 0, 1, 0, 0, 0},     // TPM_CC_PolicyCounterTimer
#endif
#if (PAD_LIST || CC_PolicyCpHash)
    {0x016e, 0, 0, 0, 0, 1, 0, 0, 0},     // TPM_CC_PolicyCpHash
#endif
#if (PAD_LIST || CC_PolicyLocality)
    {0x016f, 0, 0, 0, 0, 1, 0, 0, 0},     // TPM_CC_PolicyLocality
#endif
#if (PAD_LIST || CC_PolicyNameHash)
    {0x0170, 0, 0, 0, 0, 1, 0, 0, 0},     // TPM_CC_PolicyNameHash
#endif
#if (PAD_LIST || CC_PolicyOR)
    {0x0171, 0, 0, 0, 0, 1, 0, 0, 0},     // TPM_CC_PolicyOR
#endif
#if (PAD_LIST || CC_PolicyTicket)
    {0x0172, 0, 0, 0, 0, 1, 0, 0, 0},     // TPM_CC_PolicyTicket
#endif
#if (PAD_LIST || CC_ReadPublic)
    {0x0173, 0, 0, 0, 0, 1, 0, 0, 0},     // TPM_CC_ReadPublic
#endif
#if (PAD_LIST || CC_RSA_Encrypt)
    {0x0174, 0, 0, 0, 0, 1, 0, 0, 0},     // TPM_CC_RSA_Encrypt
#endif
#if (PAD_LIST)
    {0x0175, 0, 0, 0, 0, 0, 0, 0, 0},     // No command
#endif
#if (PAD_LIST || CC_StartAuthSession)
    {0x0176, 0, 0, 0, 0, 2, 1, 0, 0},     // TPM_CC_StartAuthSession
#endif
#if (PAD_LIST || CC_VerifySignature)
    {0x0177, 0, 0, 0, 0, 1, 0, 0, 0},     // TPM_CC_VerifySignature
#endif
#if (PAD_LIST || CC_ECC_Parameters)
    {0x0178, 0, 0, 0, 0, 0, 0, 0, 0},     // TPM_CC_ECC_Parameters
#endif
#if (PAD_LIST || CC_FirmwareRead)
    {0x0179, 0, 0, 0, 0, 0, 0, 0, 0},     // TPM_CC_FirmwareRead
#endif
#if (PAD_LIST || CC_GetCapability)
    {0x017a, 0, 0, 0, 0, 0, 0, 0, 0},     // TPM_CC_GetCapability
#endif
#if (PAD_LIST || CC_GetRandom)
    {0x017b, 0, 0, 0, 0, 0, 0, 0, 0},     // TPM_CC_GetRandom
#endif
#if (PAD_LIST || CC_GetTestResult)
    {0x017c, 0, 0, 0, 0, 0, 0, 0, 0},     // TPM_CC_GetTestResult
#endif
#if (PAD_LIST || CC_Hash)
    {0x017d, 0, 0, 0, 0, 0, 0, 0, 0},     // TPM_CC_Hash
#endif
#if (PAD_LIST || CC_PCR_Read)
    {0x017e, 0, 0, 0, 0, 0, 0, 0, 0},     // TPM_CC_PCR_Read
#endif
#if (PAD_LIST || CC_PolicyPCR)
    {0x017f, 0, 0, 0, 0, 1, 0, 0, 0},     // TPM_CC_PolicyPCR
#endif
#if (PAD_LIST || CC_PolicyRestart)
    {0x0180, 0, 0, 0, 0, 1, 0, 0, 0},     // TPM_CC_PolicyRestart
#endif
#if (PAD_LIST || CC_ReadClock)
    {0x0181, 0, 0, 0, 0, 0, 0, 0, 0},     // TPM_CC_ReadClock
#endif
#if (PAD_LIST || CC_PCR_Extend)
    {0x0182, 0, 1, 0, 0, 1, 0, 0, 0},     // TPM_CC_PCR_Extend
#endif
#if (PAD_LIST || CC_PCR_SetAuthValue)
    {0x0183, 0, 0, 0, 0, 1, 0, 0, 0},     // TPM_CC_PCR_SetAuthValue
#endif
#if (PAD_LIST || CC_NV_Certify)
    {0x0184, 0, 0, 0, 0, 3, 0, 0, 0},     // TPM_CC_NV_Certify
#endif
#if (PAD_LIST || CC_EventSequenceComplete)
    {0x0185, 0, 1, 0, 1, 2, 0, 0, 0},     // TPM_CC_EventSequenceComplete
#endif
#if (PAD_LIST || CC_HashSequenceStart)
    {0x0186, 0, 0, 0, 0, 0, 1, 0, 0},     // TPM_CC_HashSequenceStart
#endif
#if (PAD_LIST || CC_PolicyPhysicalPresence)
    {0x0187, 0, 0, 0, 0, 1, 0, 0, 0},     // TPM_CC_PolicyPhysicalPresence
#endif
#if (PAD_LIST || CC_PolicyDuplicationSelect)
    {0x0188, 0, 0, 0, 0, 1, 0, 0, 0},     // TPM_CC_PolicyDuplicationSelect
#endif
#if (PAD_LIST || CC_PolicyGetDigest)
    {0x0189, 0, 0, 0, 0, 1, 0, 0, 0},     // TPM_CC_PolicyGetDigest
#endif
#if (PAD_LIST || CC_TestParms)
    {0x018a, 0, 0, 0, 0, 0, 0, 0, 0},     // TPM_CC_TestParms
#endif
#if (PAD_LIST || CC_Commit)
    {0x018b, 0, 0, 0, 0, 1, 0, 0, 0},     // TPM_CC_Commit
#endif
#if (PAD_LIST || CC_PolicyPassword)
    {0x018c, 0, 0, 0, 0, 1, 0, 0, 0},     // TPM_CC_PolicyPassword
#endif
#if (PAD_LIST || CC_ZGen_2Phase)
    {0x018d, 0, 0, 0, 0, 1, 0, 0, 0},     // TPM_CC_ZGen_2Phase
#endif
#if (PAD_LIST || CC_EC_Ephemeral)
    {0x018e, 0, 0, 0, 0, 0, 0, 0, 0},     // TPM_CC_EC_Ephemeral
#endif
#if (PAD_LIST || CC_PolicyNvWritten)
    {0x018f, 0, 0, 0, 0, 1, 0, 0, 0},     // TPM_CC_PolicyNvWritten
#endif
#if (PAD_LIST || CC_Vendor_TCG_Test)
    {0x0000, 0, 0, 0, 0, 0, 0, 1, 0},     // TPM_CC_Vendor_TCG_Test
#endif
    0
};

#endif // TPM_TIS_NO_COMMAND_FILTERING

