/* mbed TCG SPI TPM 2.0 TIS 1.3 driver,
 * Copyright (c) 2015, Microsoft Coprporation Inc.
 * by Stefan Thom (LordOfDorks) StefanTh@Microsoft.com, Stefan@ThomsR.Us
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 */

#ifndef min
#define min(a,b) (((a) < (b)) ? (a) : (b))
#endif

#ifndef max
#define max(a,b) (((a) > (b)) ? (a) : (b))
#endif
  
#define ALL_FLAGS_SET(__value, __flags) \
((__value & __flags) == __flags) \

#define TIS_BASE_ADDRESS (0x00d40000)
#define TIS_HEADER(__LOCALITY, __READCYCLE, __REGISTER, __PAYLOAD)\
(TIS_BASE_ADDRESS | \
 (__READCYCLE ? 0x80000000 : 0x00000000) | \
 ((__PAYLOAD - 1) << 24) | \
 (__LOCALITY << 12) | \
 (__REGISTER))

// Empty Assert
#define pAssert(a)

// Aggregate bytes into an UINT
#define BYTE_ARRAY_TO_UINT8(b)   (UINT8)((b)[0])

#define BYTE_ARRAY_TO_UINT16(b)  (UINT16)(  ((b)[0] <<  8) \
                                          +  (b)[1])

#define BYTE_ARRAY_TO_UINT32(b)  (UINT32)(  ((b)[0] << 24) \
                                          + ((b)[1] << 16) \
                                          + ((b)[2] << 8 ) \
                                          +  (b)[3])

#define BYTE_ARRAY_TO_UINT64(b)  (UINT64)(  ((UINT64)(b)[0] << 56) \
                                          + ((UINT64)(b)[1] << 48) \
                                          + ((UINT64)(b)[2] << 40) \
                                          + ((UINT64)(b)[3] << 32) \
                                          + ((UINT64)(b)[4] << 24) \
                                          + ((UINT64)(b)[5] << 16) \
                                          + ((UINT64)(b)[6] <<  8) \
                                          +  (UINT64)(b)[7])

#define BYTE_ARRAY_TO_LEUINT16(b)  (UINT16)(  ((b)[1] <<  8) \
                                            +  (b)[0])

#define BYTE_ARRAY_TO_LEUINT32(b)  (UINT32)(  ((b)[3] << 24) \
                                            + ((b)[2] << 16) \
                                            + ((b)[1] << 8 ) \
                                            +  (b)[0])

#define BYTE_ARRAY_TO_LEUINT64(b)  (UINT64)(  ((UINT64)(b)[7] << 56) \
                                            + ((UINT64)(b)[6] << 48) \
                                            + ((UINT64)(b)[5] << 40) \
                                            + ((UINT64)(b)[4] << 32) \
                                            + ((UINT64)(b)[3] << 24) \
                                            + ((UINT64)(b)[2] << 16) \
                                            + ((UINT64)(b)[1] <<  8) \
                                            +  (UINT64)(b)[0])

// Disaggregate a UINT into a byte array
#define UINT8_TO_BYTE_ARRAY(i, b)     ((b)[0] = (BYTE)(i), i)

#define UINT16_TO_BYTE_ARRAY(i, b)    ((b)[0] = (BYTE)((i) >>  8), \
                                       (b)[1] = (BYTE) (i),        \
                                       (i))

#define UINT32_TO_BYTE_ARRAY(i, b)    ((b)[0] = (BYTE)((i) >> 24), \
                                       (b)[1] = (BYTE)((i) >> 16), \
                                       (b)[2] = (BYTE)((i) >>  8), \
                                       (b)[3] = (BYTE) (i),        \
                                       (i))

#define UINT64_TO_BYTE_ARRAY(i, b)    ((b)[0] = (BYTE)((i) >> 56), \
                                       (b)[1] = (BYTE)((i) >> 48), \
                                       (b)[2] = (BYTE)((i) >> 40), \
                                       (b)[3] = (BYTE)((i) >> 32), \
                                       (b)[4] = (BYTE)((i) >> 24), \
                                       (b)[5] = (BYTE)((i) >> 16), \
                                       (b)[6] = (BYTE)((i) >>  8), \
                                       (b)[7] = (BYTE) (i),        \
                                       (i))

#define LEUINT16_TO_BYTE_ARRAY(i, b)    ((b)[1] = (BYTE)((i) >>  8), \
                                         (b)[0] = (BYTE) (i),        \
                                         (i))

#define LEUINT32_TO_BYTE_ARRAY(i, b)    ((b)[3] = (BYTE)((i) >> 24), \
                                         (b)[2] = (BYTE)((i) >> 16), \
                                         (b)[1] = (BYTE)((i) >>  8), \
                                         (b)[0] = (BYTE) (i),        \
                                         (i))

#define LEUINT64_TO_BYTE_ARRAY(i, b)    ((b)[7] = (BYTE)((i) >> 56), \
                                         (b)[6] = (BYTE)((i) >> 48), \
                                         (b)[5] = (BYTE)((i) >> 40), \
                                         (b)[4] = (BYTE)((i) >> 32), \
                                         (b)[3] = (BYTE)((i) >> 24), \
                                         (b)[2] = (BYTE)((i) >> 16), \
                                         (b)[1] = (BYTE)((i) >>  8), \
                                         (b)[0] = (BYTE) (i),        \
                                         (i))

